/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import com.sun.jna.Platform;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.RuntimeInternals;

public final class HeapEstimator {
    public static final int OBJECT_REFERENCE_BYTES;
    public static final int OBJECT_HEADER_BYTES;
    public static final int ARRAY_HEADER_BYTES;
    public static final int OBJECT_ALIGNMENT_BYTES;
    public static final long LOCAL_TIME_SIZE;
    public static final long LOCAL_DATE_SIZE;
    public static final long OFFSET_TIME_SIZE;
    public static final long LOCAL_DATE_TIME_SIZE;
    public static final long ZONED_DATE_TIME_SIZE;
    public static final long SCOPED_MEMORY_TRACKER_SHALLOW_SIZE;
    private static final Map<Class<?>, Integer> PRIMITIVE_SIZES;
    public static final int LONG_SIZE;
    private static final int STRING_SIZE;
    private static final int MAX_DEPTH = 1;
    private static final long HASH_MAP_SHALLOW_SIZE;
    public static final long HASH_MAP_NODE_SHALLOW_SIZE;

    private HeapEstimator() {
    }

    public static long alignObjectSize(long size) {
        return size + (long)OBJECT_ALIGNMENT_BYTES - 1L & (long)(-OBJECT_ALIGNMENT_BYTES);
    }

    public static long sizeOf(Long value) {
        if (value >= RuntimeInternals.LONG_CACHE_MIN_VALUE && value <= RuntimeInternals.LONG_CACHE_MAX_VALUE) {
            return 0L;
        }
        return LONG_SIZE;
    }

    public static long shallowSizeOfObjectArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + (long)OBJECT_REFERENCE_BYTES * (long)size);
    }

    public static long sizeOfByteArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 1L * (long)size);
    }

    public static long sizeOfIntArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 4L * (long)size);
    }

    public static long sizeOfLongArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 8L * (long)size);
    }

    public static long sizeOfFloatArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 4L * (long)size);
    }

    public static long sizeOfDoubleArray(int size) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 8L * (long)size);
    }

    public static long sizeOfObjectArray(long elementSize, int size) {
        return HeapEstimator.shallowSizeOfObjectArray(size) + elementSize * (long)size;
    }

    public static long sizeOf(byte[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + (long)arr.length);
    }

    public static long sizeOf(boolean[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + (long)arr.length);
    }

    public static long sizeOf(char[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 2L * (long)arr.length);
    }

    public static long sizeOf(short[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 2L * (long)arr.length);
    }

    public static long sizeOf(int[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 4L * (long)arr.length);
    }

    public static long sizeOf(float[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 4L * (long)arr.length);
    }

    public static long sizeOf(long[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 8L * (long)arr.length);
    }

    public static long sizeOf(double[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + 8L * (long)arr.length);
    }

    public static long sizeOf(String[] arr) {
        long size = HeapEstimator.shallowSizeOf(arr);
        for (String s : arr) {
            if (s == null) continue;
            size += HeapEstimator.sizeOf(s);
        }
        return size;
    }

    public static long sizeOfHashMap(Map<?, ?> map) {
        int size = map.size();
        int tableSize = HashMapNode.tableSizeFor(size);
        return HASH_MAP_SHALLOW_SIZE + HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + (long)OBJECT_REFERENCE_BYTES * (long)tableSize) + HASH_MAP_NODE_SHALLOW_SIZE * (long)size;
    }

    private static long sizeOfMap(Map<?, ?> map, int depth, long defSize) {
        if (map == null) {
            return 0L;
        }
        long size = HeapEstimator.shallowSizeOf(map);
        if (depth > 1) {
            return size;
        }
        long sizeOfEntry = -1L;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sizeOfEntry == -1L) {
                sizeOfEntry = HeapEstimator.shallowSizeOf(entry);
            }
            size += sizeOfEntry;
            size += HeapEstimator.sizeOfObject(entry.getKey(), depth, defSize);
            size += HeapEstimator.sizeOfObject(entry.getValue(), depth, defSize);
        }
        return HeapEstimator.alignObjectSize(size);
    }

    private static long sizeOfCollection(Collection<?> collection, int depth, long defSize) {
        if (collection == null) {
            return 0L;
        }
        long size = HeapEstimator.shallowSizeOf(collection);
        if (depth > 1) {
            return size;
        }
        size += (long)(ARRAY_HEADER_BYTES + collection.size() * OBJECT_REFERENCE_BYTES);
        for (Object o : collection) {
            size += HeapEstimator.sizeOfObject(o, depth, defSize);
        }
        return HeapEstimator.alignObjectSize(size);
    }

    private static long sizeOfObject(Object o, int depth, long defSize) {
        if (o == null) {
            return 0L;
        }
        long size = o instanceof String ? HeapEstimator.sizeOf((String)o) : (o instanceof boolean[] ? HeapEstimator.sizeOf((boolean[])o) : (o instanceof byte[] ? HeapEstimator.sizeOf((byte[])o) : (o instanceof char[] ? HeapEstimator.sizeOf((char[])o) : (o instanceof double[] ? HeapEstimator.sizeOf((double[])o) : (o instanceof float[] ? HeapEstimator.sizeOf((float[])o) : (o instanceof int[] ? HeapEstimator.sizeOf((int[])o) : (o instanceof Long ? HeapEstimator.sizeOf((Long)o) : (o instanceof long[] ? HeapEstimator.sizeOf((long[])o) : (o instanceof short[] ? HeapEstimator.sizeOf((short[])o) : (o instanceof String[] ? HeapEstimator.sizeOf((String[])o) : (o instanceof Map ? HeapEstimator.sizeOfMap((Map)o, ++depth, defSize) : (o instanceof Collection ? HeapEstimator.sizeOfCollection((Collection)o, ++depth, defSize) : (defSize > 0L ? defSize : HeapEstimator.shallowSizeOf(o))))))))))))));
        return size;
    }

    public static long sizeOf(String s) {
        if (s == null) {
            return 0L;
        }
        long size = STRING_SIZE + ARRAY_HEADER_BYTES + RuntimeInternals.stringBackingArraySize(s);
        return HeapEstimator.alignObjectSize(size);
    }

    public static long sizeOf(Object o) {
        return HeapEstimator.sizeOfObject(o, 0, 0L);
    }

    public static long shallowSizeOf(Object[] arr) {
        return HeapEstimator.alignObjectSize((long)ARRAY_HEADER_BYTES + (long)OBJECT_REFERENCE_BYTES * (long)arr.length);
    }

    public static long shallowSizeOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clz = obj.getClass();
        if (clz.isArray()) {
            return HeapEstimator.shallowSizeOfArray(obj);
        }
        return HeapEstimator.shallowSizeOfInstance(clz);
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return PRIMITIVE_SIZES.get(clazz).intValue();
        }
        long size = OBJECT_HEADER_BYTES;
        if (clazz.isRecord()) {
            for (RecordComponent r : clazz.getRecordComponents()) {
                Class<?> type = r.getType();
                int fieldSize = type.isPrimitive() ? PRIMITIVE_SIZES.get(type) : OBJECT_REFERENCE_BYTES;
                size += (long)fieldSize;
            }
        } else {
            while (clazz != null) {
                for (Field f : clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    Class<?> type = f.getType();
                    int fieldSize = type.isPrimitive() ? PRIMITIVE_SIZES.get(type) : OBJECT_REFERENCE_BYTES;
                    size = Math.max(size, UnsafeUtil.getFieldOffset(f) + (long)fieldSize);
                }
                clazz = clazz.getSuperclass();
            }
        }
        return HeapEstimator.alignObjectSize(size);
    }

    public static long shallowSizeOfInstanceWithObjectReferences(int numberOfObjectReferences) {
        return HeapEstimator.alignObjectSize((long)OBJECT_HEADER_BYTES + (long)numberOfObjectReferences * (long)OBJECT_REFERENCE_BYTES);
    }

    public static boolean hasCompressedOOPS() {
        return RuntimeInternals.COMPRESSED_OOPS;
    }

    private static long shallowSizeOfArray(Object array) {
        long size = ARRAY_HEADER_BYTES;
        int len = Array.getLength(array);
        if (len > 0) {
            Class<?> arrayElementClazz = array.getClass().getComponentType();
            size = arrayElementClazz.isPrimitive() ? (size += (long)len * (long)PRIMITIVE_SIZES.get(arrayElementClazz).intValue()) : (size += (long)OBJECT_REFERENCE_BYTES * (long)len);
        }
        return HeapEstimator.alignObjectSize(size);
    }

    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Integer> primitiveSizesMap = new IdentityHashMap<Class<Comparable<Boolean>>, Integer>(8);
        primitiveSizesMap.put(Boolean.TYPE, 1);
        primitiveSizesMap.put(Byte.TYPE, 1);
        primitiveSizesMap.put(Character.TYPE, 2);
        primitiveSizesMap.put(Short.TYPE, 2);
        primitiveSizesMap.put(Integer.TYPE, 4);
        primitiveSizesMap.put(Float.TYPE, 4);
        primitiveSizesMap.put(Double.TYPE, 8);
        primitiveSizesMap.put(Long.TYPE, 8);
        PRIMITIVE_SIZES = Collections.unmodifiableMap(primitiveSizesMap);
        if (Platform.is64Bit()) {
            OBJECT_ALIGNMENT_BYTES = RuntimeInternals.OBJECT_ALIGNMENT;
            OBJECT_REFERENCE_BYTES = RuntimeInternals.COMPRESSED_OOPS ? 4 : 8;
            OBJECT_HEADER_BYTES = RuntimeInternals.HEADER_SIZE;
            ARRAY_HEADER_BYTES = (int)HeapEstimator.alignObjectSize(OBJECT_HEADER_BYTES + 4);
        } else {
            OBJECT_ALIGNMENT_BYTES = 8;
            OBJECT_REFERENCE_BYTES = 4;
            OBJECT_HEADER_BYTES = 8;
            ARRAY_HEADER_BYTES = OBJECT_HEADER_BYTES + 4;
        }
        LONG_SIZE = (int)HeapEstimator.shallowSizeOfInstance(Long.class);
        STRING_SIZE = (int)HeapEstimator.shallowSizeOfInstance(String.class);
        if (RuntimeInternals.DEBUG_ESTIMATIONS) {
            System.err.println(String.format("### %s static values: ###%n  NUM_BYTES_OBJECT_ALIGNMENT=%d%n  NUM_BYTES_OBJECT_REF=%d%n  NUM_BYTES_OBJECT_HEADER=%d%n  NUM_BYTES_ARRAY_HEADER=%d%n  LONG_SIZE=%d%n  STRING_SIZE=%d%n  STRING_VALUE_ARRAY=%s%n", HeapEstimator.class.getName(), OBJECT_ALIGNMENT_BYTES, OBJECT_REFERENCE_BYTES, OBJECT_HEADER_BYTES, ARRAY_HEADER_BYTES, LONG_SIZE, STRING_SIZE, RuntimeInternals.STRING_VALUE_ARRAY != null));
        }
        LOCAL_TIME_SIZE = HeapEstimator.shallowSizeOfInstance(LocalTime.class);
        LOCAL_DATE_SIZE = HeapEstimator.shallowSizeOfInstance(LocalDate.class);
        OFFSET_TIME_SIZE = HeapEstimator.shallowSizeOfInstance(OffsetTime.class) + LOCAL_TIME_SIZE;
        LOCAL_DATE_TIME_SIZE = HeapEstimator.shallowSizeOfInstance(LocalDateTime.class) + LOCAL_DATE_SIZE + LOCAL_TIME_SIZE;
        ZONED_DATE_TIME_SIZE = HeapEstimator.shallowSizeOfInstance(ZonedDateTime.class) + LOCAL_DATE_TIME_SIZE;
        SCOPED_MEMORY_TRACKER_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DefaultScopedMemoryTracker.class);
        HASH_MAP_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HashMap.class);
        HASH_MAP_NODE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HashMapNode.class);
    }

    private static class HashMapNode {
        int hash;
        Object key;
        Object value;
        Object next;

        private HashMapNode() {
        }

        static int tableSizeFor(int cap) {
            int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
            return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        }
    }
}

