/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DatabaseException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.TokenExpiredException;
import org.neo4j.driver.exceptions.TransactionTerminatedException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.messaging.GqlError;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static ServiceUnavailableException newConnectionTerminatedError(String reason) {
        if (reason == null) {
            return ErrorUtil.newConnectionTerminatedError();
        }
        return new ServiceUnavailableException("Connection to the database terminated. " + reason);
    }

    public static ServiceUnavailableException newConnectionTerminatedError() {
        return new ServiceUnavailableException("Connection to the database terminated. Please ensure that your database is listening on the correct host and port and that you have compatible encryption settings both on Neo4j server and driver. Note that the default encryption setting has changed in Neo4j 4.0.");
    }

    public static ResultConsumedException newResultConsumedError() {
        return new ResultConsumedException("Cannot access records on this result any more as the result has already been consumed or the query runner where the result is created has already been closed.");
    }

    public static Neo4jException newNeo4jError(GqlError gqlError) {
        String code = gqlError.code();
        switch (ErrorUtil.extractErrorClass(code)) {
            case "ClientError": {
                if ("Security".equals(ErrorUtil.extractErrorSubClass(code))) {
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.Unauthorized")) {
                        return new AuthenticationException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                    }
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.AuthorizationExpired")) {
                        return new AuthorizationExpiredException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                    }
                    if (code.equalsIgnoreCase("Neo.ClientError.Security.TokenExpired")) {
                        return new TokenExpiredException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                    }
                    return new SecurityException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Database.DatabaseNotFound")) {
                    return new FatalDiscoveryException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                }
                if (code.equalsIgnoreCase("Neo.ClientError.Transaction.Terminated")) {
                    return new TransactionTerminatedException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                }
                return new ClientException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
            }
            case "TransientError": {
                if ("Neo.TransientError.Transaction.Terminated".equals(code)) {
                    return new TransactionTerminatedException(gqlError.gqlStatus(), gqlError.statusDescription(), "Neo.ClientError.Transaction.Terminated", gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                }
                if ("Neo.TransientError.Transaction.LockClientStopped".equals(code)) {
                    return new ClientException(gqlError.gqlStatus(), gqlError.statusDescription(), "Neo.ClientError.Transaction.LockClientStopped", gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
                }
                return new TransientException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
            }
        }
        return new DatabaseException(gqlError.gqlStatus(), gqlError.statusDescription(), code, gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
    }

    public static Neo4jException map(GqlError gqlError) {
        if (gqlError == null) {
            return null;
        }
        return new Neo4jException(gqlError.gqlStatus(), gqlError.statusDescription(), gqlError.code(), gqlError.message(), gqlError.diagnosticRecord(), ErrorUtil.map(gqlError.cause()));
    }

    public static boolean isFatal(Throwable error) {
        if (error instanceof Neo4jException) {
            if (ErrorUtil.isProtocolViolationError((Neo4jException)error)) {
                return true;
            }
            return !ErrorUtil.isClientOrTransientError((Neo4jException)error);
        }
        return true;
    }

    public static void rethrowAsyncException(ExecutionException e) {
        RuntimeException exception;
        Throwable error = e.getCause();
        InternalExceptionCause internalCause = new InternalExceptionCause(error.getStackTrace());
        error.addSuppressed(internalCause);
        StackTraceElement[] currentStackTrace = (StackTraceElement[])Stream.of(Thread.currentThread().getStackTrace()).skip(2L).toArray(StackTraceElement[]::new);
        error.setStackTrace(currentStackTrace);
        if (error instanceof RuntimeException) {
            exception = (RuntimeException)error;
        } else {
            String message = "Driver execution failed";
            exception = new Neo4jException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, error);
        }
        throw exception;
    }

    private static boolean isProtocolViolationError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && errorCode.startsWith("Neo.ClientError.Request");
    }

    private static boolean isClientOrTransientError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && (errorCode.contains("ClientError") || errorCode.contains("TransientError"));
    }

    private static String extractErrorClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }

    private static String extractErrorSubClass(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 3) {
            return "";
        }
        return parts[2];
    }

    public static void addSuppressed(Throwable mainError, Throwable error) {
        if (mainError != error) {
            mainError.addSuppressed(error);
        }
    }

    private static class InternalExceptionCause
    extends RuntimeException {
        private static final long serialVersionUID = -1988733529334222027L;

        InternalExceptionCause(StackTraceElement[] stackTrace) {
            this.setStackTrace(stackTrace);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

