/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;

public class AuthContext {
    private final AuthTokenManager authTokenManager;
    private AuthToken authToken;
    private Long authTimestamp;
    private boolean pendingLogoff;
    private boolean managed;
    private AuthToken validToken;

    public AuthContext(AuthTokenManager authTokenManager) {
        Objects.requireNonNull(authTokenManager, "authTokenProvider must not be null");
        this.authTokenManager = authTokenManager;
        this.managed = true;
    }

    public void initiateAuth(AuthToken authToken) {
        this.initiateAuth(authToken, true);
    }

    public void initiateAuth(AuthToken authToken, boolean managed) {
        Objects.requireNonNull(authToken, "authToken must not be null");
        this.authToken = authToken;
        this.authTimestamp = null;
        this.pendingLogoff = false;
        this.managed = managed;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public void finishAuth(long authTimestamp) {
        this.authTimestamp = authTimestamp;
    }

    public Long getAuthTimestamp() {
        return this.authTimestamp;
    }

    public void markPendingLogoff() {
        this.pendingLogoff = true;
    }

    public boolean isPendingLogoff() {
        return this.pendingLogoff;
    }

    public void setValidToken(AuthToken validToken) {
        this.validToken = validToken;
    }

    public AuthToken getValidToken() {
        return this.validToken;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public AuthTokenManager getAuthTokenManager() {
        return this.authTokenManager;
    }
}

