/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.ResultSummary;

public class InternalResult
implements Result {
    private final Connection connection;
    private final ResultCursor cursor;

    public InternalResult(Connection connection, ResultCursor cursor) {
        this.connection = connection;
        this.cursor = cursor;
    }

    @Override
    public List<String> keys() {
        return this.cursor.keys();
    }

    @Override
    public boolean hasNext() {
        return this.blockingGet(this.cursor.peekAsync()) != null;
    }

    @Override
    public Record next() {
        Record record = this.blockingGet(this.cursor.nextAsync());
        if (record == null) {
            throw new NoSuchRecordException("No more records");
        }
        return record;
    }

    @Override
    public Record single() {
        return this.blockingGet(this.cursor.singleAsync());
    }

    @Override
    public Record peek() {
        Record record = this.blockingGet(this.cursor.peekAsync());
        if (record == null) {
            throw new NoSuchRecordException("Cannot peek past the last record");
        }
        return record;
    }

    @Override
    public Stream<Record> stream() {
        Spliterator<Record> spliterator = Spliterators.spliteratorUnknownSize(this, 1040);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public List<Record> list() {
        return this.blockingGet(this.cursor.listAsync());
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        return this.blockingGet(this.cursor.listAsync(mapFunction));
    }

    @Override
    public ResultSummary consume() {
        return this.blockingGet(this.cursor.consumeAsync());
    }

    @Override
    public boolean isOpen() {
        return this.blockingGet(this.cursor.isOpenAsync());
    }

    @Override
    public void remove() {
        String message = "Removing records from a result is not supported.";
        throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
    }

    private <T> T blockingGet(CompletionStage<T> stage) {
        return Futures.blockingGet(stage, this::terminateConnectionOnThreadInterrupt);
    }

    private void terminateConnectionOnThreadInterrupt() {
        this.connection.terminateAndRelease("Thread interrupted while waiting for result to arrive");
    }
}

