/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.internal.InternalNotificationConfig;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.handlers.pulln.FetchSizeUtil;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.util.DriverInfoUtil;
import org.neo4j.driver.net.ServerAddressResolver;
import org.neo4j.driver.util.Experimental;
import org.neo4j.driver.util.Immutable;
import org.neo4j.driver.util.Preview;

@Immutable
public final class Config
implements Serializable {
    private static final long serialVersionUID = -4496545746399601108L;
    private static final Config EMPTY = Config.builder().build();
    private final Logging logging;
    private final boolean logLeakedSessions;
    private final int maxConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final long maxConnectionLifetimeMillis;
    private final long connectionAcquisitionTimeoutMillis;
    private final SecuritySettings securitySettings;
    private final long fetchSize;
    private final long routingTablePurgeDelayMillis;
    private final long maxTransactionRetryTimeMillis;
    private final int connectionTimeoutMillis;
    private final ServerAddressResolver resolver;
    private final int eventLoopThreads;
    private final String userAgent;
    private final NotificationConfig notificationConfig;
    private final MetricsAdapter metricsAdapter;
    private final boolean telemetryDisabled;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.logLeakedSessions = builder.logLeakedSessions;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.maxConnectionLifetimeMillis = builder.maxConnectionLifetimeMillis;
        this.maxConnectionPoolSize = builder.maxConnectionPoolSize;
        this.connectionAcquisitionTimeoutMillis = builder.connectionAcquisitionTimeoutMillis;
        this.userAgent = builder.userAgent;
        this.securitySettings = builder.securitySettingsBuilder.build();
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.routingTablePurgeDelayMillis = builder.routingTablePurgeDelayMillis;
        this.maxTransactionRetryTimeMillis = builder.maxTransactionRetryTimeMillis;
        this.resolver = builder.resolver;
        this.fetchSize = builder.fetchSize;
        this.notificationConfig = builder.notificationConfig;
        this.eventLoopThreads = builder.eventLoopThreads;
        this.metricsAdapter = builder.metricsAdapter;
        this.telemetryDisabled = builder.telemetryDisabled;
    }

    public Logging logging() {
        return this.logging;
    }

    public boolean logLeakedSessions() {
        return this.logLeakedSessions;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public long maxConnectionLifetimeMillis() {
        return this.maxConnectionLifetimeMillis;
    }

    public int connectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int maxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public long connectionAcquisitionTimeoutMillis() {
        return this.connectionAcquisitionTimeoutMillis;
    }

    public boolean encrypted() {
        return this.securitySettings.encrypted();
    }

    public TrustStrategy trustStrategy() {
        return this.securitySettings.trustStrategy();
    }

    public ServerAddressResolver resolver() {
        return this.resolver;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return EMPTY;
    }

    public long routingTablePurgeDelayMillis() {
        return this.routingTablePurgeDelayMillis;
    }

    public long maxTransactionRetryTimeMillis() {
        return this.maxTransactionRetryTimeMillis;
    }

    public long fetchSize() {
        return this.fetchSize;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    @Preview(name="GQL-status object")
    public Optional<NotificationSeverity> minimumNotificationSeverity() {
        return Optional.ofNullable(((InternalNotificationConfig)this.notificationConfig).minimumSeverity());
    }

    @Preview(name="GQL-status object")
    public Set<NotificationClassification> disabledNotificationClassifications() {
        Set<NotificationCategory> disabledCategories = ((InternalNotificationConfig)this.notificationConfig).disabledCategories();
        return disabledCategories != null ? ((InternalNotificationConfig)this.notificationConfig).disabledCategories().stream().map(NotificationClassification.class::cast).collect(Collectors.toUnmodifiableSet()) : Collections.emptySet();
    }

    public int eventLoopThreads() {
        return this.eventLoopThreads;
    }

    public boolean isMetricsEnabled() {
        return this.metricsAdapter != MetricsAdapter.DEV_NULL;
    }

    public MetricsAdapter metricsAdapter() {
        return this.metricsAdapter;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public boolean isTelemetryDisabled() {
        return this.telemetryDisabled;
    }

    public static final class ConfigBuilder {
        private Logging logging = DevNullLogging.DEV_NULL_LOGGING;
        private boolean logLeakedSessions;
        private int maxConnectionPoolSize = 100;
        private long idleTimeBeforeConnectionTest = -1L;
        private long maxConnectionLifetimeMillis = PoolSettings.DEFAULT_MAX_CONNECTION_LIFETIME;
        private long connectionAcquisitionTimeoutMillis = PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT;
        private String userAgent = String.format("neo4j-java/%s", DriverInfoUtil.driverVersion());
        private final SecuritySettings.SecuritySettingsBuilder securitySettingsBuilder = new SecuritySettings.SecuritySettingsBuilder();
        private long routingTablePurgeDelayMillis = RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS;
        private int connectionTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(30L);
        private long maxTransactionRetryTimeMillis = ExponentialBackoffRetryLogic.DEFAULT_MAX_RETRY_TIME_MS;
        private ServerAddressResolver resolver;
        private MetricsAdapter metricsAdapter = MetricsAdapter.DEV_NULL;
        private long fetchSize = 1000L;
        private int eventLoopThreads = 0;
        private NotificationConfig notificationConfig = NotificationConfig.defaultConfig();
        private boolean telemetryDisabled = false;

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public ConfigBuilder withLeakedSessionsLogging() {
            this.logLeakedSessions = true;
            return this;
        }

        public ConfigBuilder withConnectionLivenessCheckTimeout(long value, TimeUnit unit) {
            this.idleTimeBeforeConnectionTest = unit.toMillis(value);
            return this;
        }

        public ConfigBuilder withMaxConnectionLifetime(long value, TimeUnit unit) {
            this.maxConnectionLifetimeMillis = unit.toMillis(value);
            return this;
        }

        public ConfigBuilder withMaxConnectionPoolSize(int value) {
            if (value == 0) {
                throw new IllegalArgumentException("Zero value is not supported");
            }
            this.maxConnectionPoolSize = value < 0 ? Integer.MAX_VALUE : value;
            return this;
        }

        public ConfigBuilder withConnectionAcquisitionTimeout(long value, TimeUnit unit) {
            long valueInMillis = unit.toMillis(value);
            this.connectionAcquisitionTimeoutMillis = value >= 0L ? valueInMillis : -1L;
            return this;
        }

        public ConfigBuilder withEncryption() {
            this.securitySettingsBuilder.withEncryption();
            return this;
        }

        public ConfigBuilder withoutEncryption() {
            this.securitySettingsBuilder.withoutEncryption();
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.securitySettingsBuilder.withTrustStrategy(trustStrategy);
            return this;
        }

        public ConfigBuilder withRoutingTablePurgeDelay(long delay, TimeUnit unit) {
            long routingTablePurgeDelayMillis = unit.toMillis(delay);
            if (routingTablePurgeDelayMillis < 0L) {
                throw new IllegalArgumentException(String.format("The routing table purge delay may not be smaller than 0, but was %d %s.", new Object[]{delay, unit}));
            }
            this.routingTablePurgeDelayMillis = routingTablePurgeDelayMillis;
            return this;
        }

        public ConfigBuilder withFetchSize(long size) {
            this.fetchSize = FetchSizeUtil.assertValidFetchSize(size);
            return this;
        }

        public ConfigBuilder withConnectionTimeout(long value, TimeUnit unit) {
            long connectionTimeoutMillis = unit.toMillis(value);
            if (connectionTimeoutMillis < 0L) {
                throw new IllegalArgumentException(String.format("The connection timeout may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            int connectionTimeoutMillisInt = (int)connectionTimeoutMillis;
            if ((long)connectionTimeoutMillisInt != connectionTimeoutMillis) {
                throw new IllegalArgumentException(String.format("The connection timeout must represent int value when converted to milliseconds %d.", connectionTimeoutMillis));
            }
            this.connectionTimeoutMillis = connectionTimeoutMillisInt;
            return this;
        }

        public ConfigBuilder withMaxTransactionRetryTime(long value, TimeUnit unit) {
            long maxRetryTimeMs = unit.toMillis(value);
            if (maxRetryTimeMs < 0L) {
                throw new IllegalArgumentException(String.format("The max retry time may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            this.maxTransactionRetryTimeMillis = maxRetryTimeMs;
            return this;
        }

        public ConfigBuilder withResolver(ServerAddressResolver resolver) {
            this.resolver = Objects.requireNonNull(resolver, "resolver");
            return this;
        }

        public ConfigBuilder withDriverMetrics() {
            return this.withMetricsEnabled(true);
        }

        public ConfigBuilder withoutDriverMetrics() {
            return this.withMetricsEnabled(false);
        }

        private ConfigBuilder withMetricsEnabled(boolean enabled) {
            if (!enabled) {
                this.withMetricsAdapter(MetricsAdapter.DEV_NULL);
            } else if (this.metricsAdapter == null || this.metricsAdapter == MetricsAdapter.DEV_NULL) {
                this.withMetricsAdapter(MetricsAdapter.DEFAULT);
            }
            return this;
        }

        @Experimental
        public ConfigBuilder withMetricsAdapter(MetricsAdapter metricsAdapter) {
            this.metricsAdapter = Objects.requireNonNull(metricsAdapter, "metricsAdapter");
            return this;
        }

        public ConfigBuilder withEventLoopThreads(int size) {
            if (size < 1) {
                throw new IllegalArgumentException(String.format("The event loop thread may not be smaller than 1, but was %d.", size));
            }
            this.eventLoopThreads = size;
            return this;
        }

        public ConfigBuilder withUserAgent(String userAgent) {
            if (userAgent == null || userAgent.isEmpty()) {
                throw new IllegalArgumentException("The user_agent string must not be empty");
            }
            this.userAgent = userAgent;
            return this;
        }

        public ConfigBuilder withNotificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = Objects.requireNonNull(notificationConfig, "notificationConfig must not be null");
            return this;
        }

        @Preview(name="GQL-status object")
        public ConfigBuilder withMinimumNotificationSeverity(NotificationSeverity minimumNotificationSeverity) {
            this.notificationConfig = minimumNotificationSeverity == null ? NotificationConfig.disableAllConfig() : this.notificationConfig.enableMinimumSeverity(minimumNotificationSeverity);
            return this;
        }

        @Preview(name="GQL-status object")
        public ConfigBuilder withDisabledNotificationClassifications(Set<NotificationClassification> disabledNotificationClassifications) {
            Set<NotificationCategory> disabledCategories = disabledNotificationClassifications == null ? Collections.emptySet() : disabledNotificationClassifications.stream().map(NotificationCategory.class::cast).collect(Collectors.toSet());
            this.notificationConfig = this.notificationConfig.disableCategories(disabledCategories);
            return this;
        }

        public ConfigBuilder withTelemetryDisabled(boolean telemetryDisabled) {
            this.telemetryDisabled = telemetryDisabled;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }

    public static final class TrustStrategy
    implements Serializable {
        private static final long serialVersionUID = -1631888096243987740L;
        private final Strategy strategy;
        private final List<File> certFiles;
        private boolean hostnameVerificationEnabled = true;
        private RevocationCheckingStrategy revocationCheckingStrategy = RevocationCheckingStrategy.NO_CHECKS;

        private TrustStrategy(Strategy strategy) {
            this(strategy, Collections.emptyList());
        }

        private TrustStrategy(Strategy strategy, List<File> certFiles) {
            Objects.requireNonNull(certFiles, "certFiles can't be null");
            this.strategy = strategy;
            this.certFiles = List.copyOf(certFiles);
        }

        public Strategy strategy() {
            return this.strategy;
        }

        @Deprecated
        public File certFile() {
            return this.certFiles.isEmpty() ? null : this.certFiles.get(0);
        }

        public List<File> certFiles() {
            return this.certFiles;
        }

        public boolean isHostnameVerificationEnabled() {
            return this.hostnameVerificationEnabled;
        }

        public TrustStrategy withHostnameVerification() {
            this.hostnameVerificationEnabled = true;
            return this;
        }

        public TrustStrategy withoutHostnameVerification() {
            this.hostnameVerificationEnabled = false;
            return this;
        }

        public static TrustStrategy trustCustomCertificateSignedBy(File ... certFiles) {
            Objects.requireNonNull(certFiles, "certFiles can't be null");
            if (certFiles.length == 0) {
                throw new IllegalArgumentException("certFiles can't be empty");
            }
            return new TrustStrategy(Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, Arrays.asList(certFiles));
        }

        public static TrustStrategy trustSystemCertificates() {
            return new TrustStrategy(Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
        }

        public static TrustStrategy trustAllCertificates() {
            return new TrustStrategy(Strategy.TRUST_ALL_CERTIFICATES).withoutHostnameVerification();
        }

        public RevocationCheckingStrategy revocationCheckingStrategy() {
            return this.revocationCheckingStrategy;
        }

        public TrustStrategy withoutCertificateRevocationChecks() {
            this.revocationCheckingStrategy = RevocationCheckingStrategy.NO_CHECKS;
            return this;
        }

        public TrustStrategy withVerifyIfPresentRevocationChecks() {
            this.revocationCheckingStrategy = RevocationCheckingStrategy.VERIFY_IF_PRESENT;
            return this;
        }

        public TrustStrategy withStrictRevocationChecks() {
            this.revocationCheckingStrategy = RevocationCheckingStrategy.STRICT;
            return this;
        }

        public static enum Strategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }
}

