/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging.slf4j;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jLoggerFactory;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMDCAdapter;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMarkerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class SLF4JLogBridge
implements SLF4JServiceProvider {
    private static final String REQUESTED_API_VERSION = "2.0.99";
    private static final AtomicReference<InstantiationContext> CONTEXT = new AtomicReference();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ILoggerFactory loggerFactory;
    private IMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;

    public static void setInstantiationContext(Log4jLogProvider newLogProvider, List<String> classPrefixes) {
        CONTEXT.set(new InstantiationContext(newLogProvider, classPrefixes));
    }

    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    public String getRequestedApiVersion() {
        return REQUESTED_API_VERSION;
    }

    public void initialize() {
        InstantiationContext ctx = CONTEXT.get();
        if (ctx != null) {
            LOGGER.debug("Initializing [{}] with neo4j log provider with prefix filter {}.", (Object)SLF4JLogBridge.class.getSimpleName(), ctx.classPrefixes);
            SLF4JToLog4jMarkerFactory slf4JToLog4jMarkerFactory = new SLF4JToLog4jMarkerFactory();
            this.markerFactory = slf4JToLog4jMarkerFactory;
            this.loggerFactory = new SLF4JToLog4jLoggerFactory(ctx.logProvider, slf4JToLog4jMarkerFactory, ctx.classPrefixes);
            this.mdcAdapter = new SLF4JToLog4jMDCAdapter();
        } else {
            LOGGER.debug("Initializing [{}] with NOP provider.", (Object)SLF4JLogBridge.class.getSimpleName());
            this.markerFactory = new BasicMarkerFactory();
            this.loggerFactory = new NOPLoggerFactory();
            this.mdcAdapter = new NOPMDCAdapter();
        }
    }

    private record InstantiationContext(Log4jLogProvider logProvider, List<String> classPrefixes) {
    }
}

