/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import java.net.URL;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;

public class TestingSecurityManager
extends SecurityManager {
    private String executed;
    private Set<URL> remoteCodebases = new HashSet<URL>();

    @Override
    public void checkExec(String cmd) {
        this.executed = cmd;
        throw new SecurityException("Not calling executable " + cmd);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (perm instanceof RuntimePermission) {
            return;
        }
        HashSet<URL> cbs = new HashSet<URL>();
        for (Class<?> cl : this.getClassContext()) {
            if (cl.getProtectionDomain() == null || cl.getProtectionDomain().getCodeSource() == null || cl.getProtectionDomain().getCodeSource().getLocation() == null || "file".equals(cl.getProtectionDomain().getCodeSource().getLocation().getProtocol())) continue;
            cbs.add(cl.getProtectionDomain().getCodeSource().getLocation());
        }
        this.remoteCodebases.addAll(cbs);
    }

    public void assertRCE() throws Exception {
        if (this.executed != null) {
            System.err.println("Had execution of " + this.executed);
            return;
        }
        if (!this.remoteCodebases.isEmpty()) {
            System.err.println("Had execution from " + this.remoteCodebases);
            return;
        }
        throw new Exception("Did not trigger RCE");
    }
}

