/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;

public class SideEffectSecurityManager
extends SecurityManager {
    @Override
    public void checkPermission(Permission perm) {
        if (perm instanceof RuntimePermission) {
            if (SideEffectSecurityManager.checkRuntimePermission((RuntimePermission)perm)) {
                return;
            }
        } else {
            if (perm instanceof ReflectPermission) {
                return;
            }
            if (perm instanceof LoggingPermission) {
                return;
            }
            if (perm instanceof SecurityPermission) {
                return;
            }
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (perm instanceof NetPermission && perm.getName().equals("specifyStreamHandler")) {
                return;
            }
            if (perm instanceof FilePermission && perm.getActions().equals("read")) {
                return;
            }
            if (perm instanceof SerializablePermission) {
                return;
            }
        }
        super.checkPermission(perm);
    }

    @Override
    public void checkPropertyAccess(String key) {
    }

    private static boolean checkRuntimePermission(RuntimePermission perm) {
        if (perm.getName().startsWith("accessClassInPackage.")) {
            return true;
        }
        switch (perm.getName()) {
            case "setSecurityManager": {
                return true;
            }
            case "accessDeclaredMembers": {
                return true;
            }
            case "reflectionFactoryAccess": {
                return true;
            }
            case "createClassLoader": {
                return true;
            }
            case "getClassLoader": {
                return true;
            }
            case "setContextClassLoader": {
                return true;
            }
            case "shutdownHooks": {
                return true;
            }
            case "loadLibrary.net": {
                return true;
            }
            case "getProtectionDomain": {
                return true;
            }
            case "accessSystemModules": {
                return true;
            }
        }
        return false;
    }
}

