import pdb
import sys
import os
import mock
import pytest
from Queue import Queue
import ConfigParser
sys.path.append(os.path.abspath('../modules'))
sys.path.append(os.path.abspath('../'))
sys.path.append(os.path.abspath('../lib'))

from qark.modules import common
from qark.modules import  filePermissions
from qark.modules import  webviews
from qark.modules import  cryptoFlaws
from qark.modules import  certValidation
from qark.modules import  findPending
from qark.modules import  findBroadcasts


def get_all_java_files():
	return ['./testData/goatdroid/classes_dex2jar/android/support/v4/accessibilityservice/AccessibilityServiceInfoCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/accessibilityservice/AccessibilityServiceInfoCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/_ActionBarSherlockTrojanHorse.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ActivityCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ActivityCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/BackStackRecord.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/BackStackState.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/DialogFragment.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/Fragment.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentActivity.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentManager.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentManagerImpl.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentManagerState.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentPagerAdapter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentState.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentStatePagerAdapter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/FragmentTransaction.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/HCSparseArray.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ListFragment.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/LoaderManager.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/LoaderManagerImpl.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/NavUtils.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/NoSaveStateFrameLayout.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/NotificationCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/NotificationCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ServiceCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ShareCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/ShareCompatICS.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/SuperNotCalledException.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/TaskStackBuilder.java', './testData/goatdroid/classes_dex2jar/android/support/v4/app/TaskStackBuilderHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/AsyncTaskLoader.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/CursorLoader.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/IntentCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/Loader.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/LocalBroadcastManager.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/ModernAsyncTask.java', './testData/goatdroid/classes_dex2jar/android/support/v4/content/pm/ActivityInfoCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/database/DatabaseUtilsCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/os/ParcelableCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/os/ParcelableCompatCreatorCallbacks.java', './testData/goatdroid/classes_dex2jar/android/support/v4/os/ParcelableCompatCreatorHoneycombMR2.java', './testData/goatdroid/classes_dex2jar/android/support/v4/os/ParcelableCompatCreatorHoneycombMR2Stub.java', './testData/goatdroid/classes_dex2jar/android/support/v4/util/DebugUtils.java', './testData/goatdroid/classes_dex2jar/android/support/v4/util/LogWriter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/util/LruCache.java', './testData/goatdroid/classes_dex2jar/android/support/v4/util/TimeUtils.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/AccessibilityDelegateCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/AccessibilityDelegateCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/KeyEventCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/KeyEventCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/MenuCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/MenuItemCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/MenuItemCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/MotionEventCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/MotionEventCompatEclair.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/PagerAdapter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/PagerTitleStrip.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/VelocityTrackerCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/VelocityTrackerCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewCompatGingerbread.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewCompatICS.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewConfigurationCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewConfigurationCompatFroyo.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewGroupCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewGroupCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/ViewPager.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityEventCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityEventCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityManagerCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityManagerCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityNodeInfoCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityNodeInfoCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityRecordCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/view/accessibility/AccessibilityRecordCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/CursorAdapter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/CursorFilter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/EdgeEffectCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/EdgeEffectCompatIcs.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/ResourceCursorAdapter.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/SearchViewCompat.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/SearchViewCompatHoneycomb.java', './testData/goatdroid/classes_dex2jar/android/support/v4/widget/SimpleCursorAdapter.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/ActionBarSherlock.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/R.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/ActionBar.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockActivity.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockDialogFragment.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockExpandableListActivity.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockFragment.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockFragmentActivity.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockListActivity.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockListFragment.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/app/SherlockPreferenceActivity.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/ActionBarSherlockCompat.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/ActionBarSherlockNative.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/ResourcesCompat.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/app/ActionBarImpl.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/app/ActionBarWrapper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/Animator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/AnimatorListenerAdapter.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/AnimatorSet.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/FloatEvaluator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/FloatKeyframeSet.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/IntEvaluator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/IntKeyframeSet.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/Keyframe.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/KeyframeSet.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/ObjectAnimator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/PropertyValuesHolder.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/TypeEvaluator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/animation/ValueAnimator.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/view/NineViewGroup.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/view/animation/AnimatorProxy.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/widget/NineFrameLayout.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/widget/NineHorizontalScrollView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/nineoldandroids/widget/NineLinearLayout.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/ActionProviderWrapper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/StandaloneActionMode.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/View_HasStateListenerSupport.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/View_OnAttachStateChangeListener.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ActionMenu.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ActionMenuItem.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ActionMenuItemView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ActionMenuPresenter.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ActionMenuView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/BaseMenuPresenter.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/ListMenuItemView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuBuilder.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuItemImpl.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuItemWrapper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuPopupHelper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuPresenter.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/MenuWrapper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/SubMenuBuilder.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/view/menu/SubMenuWrapper.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/AbsActionBarView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/ActionBarContainer.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/ActionBarContextView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/ActionBarView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/CapitalizingButton.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/CapitalizingTextView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/FakeDialogPhoneWindow.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsAbsSpinner.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsAdapterView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsLinearLayout.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsListPopupWindow.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsProgressBar.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsSpinner.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/IcsView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/internal/widget/ScrollingTabContainerView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/ActionMode.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/ActionProvider.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/CollapsibleActionView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/Menu.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/MenuInflater.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/MenuItem.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/SubMenu.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/view/Window.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/widget/ActivityChooserModel.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/widget/ActivityChooserView.java', './testData/goatdroid/classes_dex2jar/com/actionbarsherlock/widget/ShareActionProvider.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/BuildConfig.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/R.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/About.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/AddVenue.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/AdminHome.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/AdminOptions.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Checkins.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/DestinationInfo.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/DoAdminDeleteUser.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/DoAdminPasswordReset.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/DoComment.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Friends.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/GenericWebViewActivity.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Home.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Login.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Main.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Preferences.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Register.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/Rewards.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/SendSMS.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/SocialAPIAuthentication.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewFriendRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewProfile.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/adapter/AvailableRewardsAdapter.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/adapter/SearchForFriendsAdapter.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/BaseActivity.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/BaseFragmentActivity.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/BaseTabsViewPagerActivity.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/BaseUnauthenticatedActivity.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/RequestBase.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/base/ResponseBase.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/broadcastreceivers/SendSMSNowReceiver.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/db/CheckinDBHelper.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/db/UserInfoDBHelper.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/AvailableRewards.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/DeleteUsers.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/DoCheckin.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/MyFriends.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/MyRewards.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/PendingFriendRequests.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/ResetUserPasswords.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/SearchForFriends.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/javascriptinterfaces/SmsJSInterface.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/javascriptinterfaces/ViewCheckinJSInterface.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/javascriptinterfaces/WebViewJSInterface.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/misc/Constants.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/misc/Utils.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/AuthenticatedRestClient.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/RequestMethod.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/ResponseBase.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/RestClient.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/addvenue/AddVenueRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/addvenue/AddVenueResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/admin/AdminRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/admin/AdminResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/checkin/CheckinRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/checkin/CheckinResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/comments/CommentsRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/comments/CommentsResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/friends/FriendRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/friends/FriendResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/history/HistoryRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/history/HistoryResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/login/LoginRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/login/LoginResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/preferences/PreferencesRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/preferences/PreferencesResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/register/RegisterRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/register/RegisterResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/rewards/RewardsRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/rewards/RewardsResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/searchforfriends/SearchForFriendsRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/searchforfriends/SearchForFriendsResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/viewcheckin/ViewCheckinRequest.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/rest/viewcheckin/ViewCheckinResponse.java', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/services/LocationService.java']

rootGoatdroidDir = ('./testData/goatdroid')

@pytest.fixture
def findAllJavaFiles():
	return common.find_java(rootGoatdroidDir)

def findAllXmlFiles():
	return common.find_xml(rootGoatdroidDir)

def setup():
    common.java_files = get_all_java_files()
    config = ConfigParser.RawConfigParser()
    script_location=os.path.dirname(os.path.abspath(__file__))
    script_location+='/../modules/config.properties'
    with open(script_location,'r') as f:
    	body = f.read()
    config.read(script_location)
    common.config = config
    
def test_certValidation():
    setup()

    output = Queue()
    certValidation.validate(output, 2)
    output = output.get()
    outputTups = [x if type(x) is str else terminalPrintToTuple(x) if x.__class__.__name__ == 'terminalPrint' else reportIssueToTuple(x) for x in output]

    assert outputTups == ['Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', (7, "Instance of checkServerTrusted, with no body found in: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This means this application is likely vulnerable to Man-In-The-Middle attacks. This can be confirmed using the free version of Burpsuite. Simply set the Android device's proxy to use Burpsuite via the network settings, but DO NOT install the Portswigger CA certificate on the device. If you still see traffic in the proxy, the app is vulnerable. Note: You need to ensure you exercise this code path. If you are unsure, make sure you click through each part of the application which makes network requests. You may need to toggle the proxy on/off to get past sections that do validate certificates properly in order to reach the vulnerable code. This proves that it will accept certificates from any CA. You should always validate your configuration by visiting an HTTPS site in the native browser and verifying you receive a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java', '', 1), ("Instance of checkServerTrusted, with no body found in: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This means this application is likely vulnerable to Man-In-The-Middle attacks. This can be confirmed using the free version of Burpsuite. Simply set the Android device's proxy to use Burpsuite via the network settings, but DO NOT install the Portswigger CA certificate on the device. If you still see traffic in the proxy, the app is vulnerable. Note: You need to ensure you exercise this code path. If you are unsure, make sure you click through each part of the application which makes network requests. You may need to toggle the proxy on/off to get past sections that do validate certificates properly in order to reach the vulnerable code. This proves that it will accept certificates from any CA. You should always validate your configuration by visiting an HTTPS site in the native browser and verifying you receive a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, 1), (7, "ALLOW_ALL_HOSTNAME_VERIFIER invoked : org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER in ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This can allow for impromper x.509 certificate validation wherein the DNS hostname does not match the Common or Subject Alternative Name(s) on the certificate, making the application vulnerable to Man-In-The-Middle attacks. This means the application may potentially accept a certificate from any trusted CA, regardless of the domain it was issued for. The can be validated using the free version of Burpsuite by installing the Portswigger CA certificate, thereby making it a trusted CA on the device. Set the device network settings to use the Burpsuite proxy, then go Proxy > Options > Edit the Proxy Listener by changing the Certificate tab to Generate a CA-signed certificate with a specific hostname and enter a domain like foobar.com which doesn't match the domain name(s) the app is connecting to normally. You should always verify your results by visiting an https site in the native browser and confirming you see a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java', '', 1), ("ALLOW_ALL_HOSTNAME_VERIFIER invoked : org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER in ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This can allow for impromper x.509 certificate validation wherein the DNS hostname does not match the Common or Subject Alternative Name(s) on the certificate, making the application vulnerable to Man-In-The-Middle attacks. This means the application may potentially accept a certificate from any trusted CA, regardless of the domain it was issued for. The can be validated using the free version of Burpsuite by installing the Portswigger CA certificate, thereby making it a trusted CA on the device. Set the device network settings to use the Burpsuite proxy, then go Proxy > Options > Edit the Proxy Listener by changing the Certificate tab to Generate a CA-signed certificate with a specific hostname and enter a domain like foobar.com which doesn't match the domain name(s) the app is connecting to normally. You should always verify your results by visiting an https site in the native browser and confirming you see a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, 1), 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.']

def test_findPending():   
    setup()

    output = Queue()
    findPending.start(output, 3) #2nd var doesn't do anything
    fpOut = output.get()
    fpTup = [x if type(x) is str else terminalPrintToTuple(x) if x.__class__.__name__ == 'terminalPrint' else reportIssueToTuple(x) for x in fpOut]
    assert fpTup == [(2, 'Implicit Intent: localIntent used to create instance of PendingIntent. A malicious application could potentially intercept, redirect and/or modify (in a limited manner) this Intent. Pending Intents retain the UID of your application and all related permissions, allowing another application to act as yours.  File: ./testData/goatdroid/classes_dex2jar/android/support/v4/app/TaskStackBuilder.java More details: https://www.securecoding.cert.org/confluence/display/android/DRD21-J.+Always+pass+explicit+intents+to+a+PendingIntent', {}, './testData/goatdroid/classes_dex2jar/android/support/v4/app/TaskStackBuilder.java', '', 3), ('Implicit Intent: localIntent used to create instance of PendingIntent. A malicious application could potentially intercept, redirect and/or modify (in a limited manner) this Intent. Pending Intents retain the UID of your application and all related permissions, allowing another application to act as yours.  File: ./testData/goatdroid/classes_dex2jar/android/support/v4/app/TaskStackBuilder.java More details: https://www.securecoding.cert.org/confluence/display/android/DRD21-J.+Always+pass+explicit+intents+to+a+PendingIntent', {}, 3)]



# currently doesn't turn up anything in the interactive version
def test_filePermissions():
    setup()

    output = Queue()
    height = 2
    filePermissions.start(output, height)
    a = []
    while not output.empty():
        a.append(output.get())
    assert a == [[]]

def reportIssueToTuple(aReportIssue):
# reportIssueTupFunc = lambda x: (x.getCategory(), x.getDetails(), x.getExtras(), x.getFile(), x.getName(), x.getSeverity())
	return (aReportIssue.getCategory(), aReportIssue.getDetails(), aReportIssue.getExtras(), aReportIssue.getFile(), aReportIssue.getName(), aReportIssue.getSeverity())
	
def terminalPrintToTuple(aTerminalPrint):
# terminalPrintTupFunc = lambda x: (x.getData(), x.getExtras(), x.getLevel())
	return (aTerminalPrint.getData(), aTerminalPrint.getExtras(), aTerminalPrint.getLevel())

# combineFunc = [ reportIssueToTuple(x) if x.__class__.__name__ == 'ReportIssue' else terminalPrintTupFunc(x) if x.__class__.__name__ == 'terminalPrint' else x for x in thisQueue]

# for some reason, can't modify the value of common in the other scope
def test_webviews():
    setup()

    output = Queue()
    webviews.validate(output)
    output = output.get()

    # is_expected_output_test_webviews_data(output)
    outputTupsAndStrs = [x if type(x) is str else terminalPrintToTuple(x) if x.__class__.__name__ == 'terminalPrint' else reportIssueToTuple(x) for x in output]
    assert outputTupsAndStrs == [('FOUND 4 WEBVIEWS:', {}, 0), ("['webview', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java']", {}, 0), ("['webview', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java']", {}, 0), ("['webview', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java']", {}, 0), ("['webview', './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java']", {}, 0), ('WebView: webview', {}, 0), ('File: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java\n', {}, 0), ('JS not enabled on this webView. webview./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {}, 0), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {'isdomstorageenabled': False}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java\n', {}, 0), (8, 'While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView. If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/JS_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html', {'isjsenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView: webview If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/JS_WARNING.htmlNote: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html\n', {}, 1), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', {'isdomstorageenabled': False}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java\n', {}, 0), ('JS not enabled on this webView. webview./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {}, 0), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {'isdomstorageenabled': False}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java\n', {}, 0), (8, 'While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView. If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/JS_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html', {'isjsenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView: webview If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/JS_WARNING.htmlNote: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html\n', {}, 1), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', {}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: ./testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', {'isdomstorageenabled': False}, './testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0)]

def is_expected_output_test_webviews_data(results):
    results = list(filter(lambda x: type(x) is not str, results))
    resultTup = list(map(lambda x: reportIssueToTuple(x) if x.__class__.__name__ == 'ReportIssue' else terminalPrintToTuple(x), results))
    assert resultTup == [('FOUND 4 WEBVIEWS:', {}, 0), ("['webview', '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java']", {}, 0), ("['webview', '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java']", {}, 0), ("['webview', '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java']", {}, 0), ("['webview', '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java']", {}, 0), ('WebView: webview', {}, 0), ('File: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java\n', {}, 0), ('JS not enabled on this webView. webview/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {}, 0), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', {'isdomstorageenabled': False}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/History.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java\n', {}, 0), (8, 'While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView. If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/JS_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html', {'isjsenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView: webview If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/JS_WARNING.htmlNote: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html\n', {}, 1), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', {'isdomstorageenabled': False}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/activities/ViewCheckin.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java\n', {}, 0), ('JS not enabled on this webView. webview/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {}, 0), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', {'isdomstorageenabled': False}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryDialogFragment.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0), ('WebView: webview', {}, 0), ('File: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java\n', {}, 0), (8, 'While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView. If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/JS_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html', {'isjsenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app has JavaScript enabled in this WebView: webview If this is not expressly necessary, you should disable it, to prevent the possibility of XSS (cross-site scripting) attacks. More info: http://developer.android.com/guide/practices/security.html To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/JS_WARNING.htmlNote: A local copy of this html file can also be found at <install_dir>/quark/poc/html/JS_WARNING.html\n', {}, 1), (8, 'BaseURL not redefined in this WebView.', {'isbaseurldefined': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('BaseURL not redefined in this WebView.', {}, 0), (8, "File system access is enabled in this WebView. If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/FILE_SYS_WARN.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html", {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ("File system access is enabled in this WebView.webview If untrusted data is used to specify the URL opened by this WebView, a malicious app or site may be able to read your app's private files, if it returns the response to them. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/FILE_SYS_WARN.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/FILE_SYS_WARN.html\n", {}, 1), (8, 'While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/WV_CPA_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html', {'iscpaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('While not a vulnerability by itself, it appears this app does not explicitly disable Content Provider access from WebViews. If the WebViews take in untrusted input, this can allow for data theft.webviewTo validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/WV_CPA_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/WV_CPA_WARNING.html\n', {}, 1), (8, 'JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions. To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/qark/poc/UNIV_FILE_WARNING.html. Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html', {'isfileaccessenabled': True}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 1), ('JavaScript running in a file scheme context can access content from any origin. This is an insecure default value for minSdkVersion < 16 or may have been overridden (setAllowUniversalAccessFromFileURLs) in later versions.webview To validate this vulnerability, load the following url in this WebView: http://www.secbro.com/poc/html/UNIV_FILE_WARNING.html Note: A local copy of this html file can also be found at <install_dir>/quark/poc/html/UNIV_FILE_WARNING.html\n', {}, 1), (8, 'addJavascriptInterface not used in this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('addJavascriptInterface not used in this WebView.webview', {}, 0), (8, 'DOM Storage not enabled for this WebView.<br>FILE: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', {'isdomstorageenabled': False}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/fragments/HistoryFragment.java', '', 0), ('DOM Storage not enabled for this WebView.webview', {}, 0)]

def test_cryptoFlaws():
    setup()

    output = Queue()
    cryptoFlaws.main(output)
    output = output.get()
    assert output == []


    # outputTupsAndStrs = [x if type(x) is str else terminalPrintTupFunc(x) if x.__class__.__name__ == 'terminalPrint' else reportIssueTupFunc(x) for x in output]

    # assert outputTupsAndStrs == ['Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.', (7, "Instance of checkServerTrusted, with no body found in: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This means this application is likely vulnerable to Man-In-The-Middle attacks. This can be confirmed using the free version of Burpsuite. Simply set the Android device's proxy to use Burpsuite via the network settings, but DO NOT install the Portswigger CA certificate on the device. If you still see traffic in the proxy, the app is vulnerable. Note: You need to ensure you exercise this code path. If you are unsure, make sure you click through each part of the application which makes network requests. You may need to toggle the proxy on/off to get past sections that do validate certificates properly in order to reach the vulnerable code. This proves that it will accept certificates from any CA. You should always validate your configuration by visiting an HTTPS site in the native browser and verifying you receive a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java', '', 1), ("Instance of checkServerTrusted, with no body found in: /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This means this application is likely vulnerable to Man-In-The-Middle attacks. This can be confirmed using the free version of Burpsuite. Simply set the Android device's proxy to use Burpsuite via the network settings, but DO NOT install the Portswigger CA certificate on the device. If you still see traffic in the proxy, the app is vulnerable. Note: You need to ensure you exercise this code path. If you are unsure, make sure you click through each part of the application which makes network requests. You may need to toggle the proxy on/off to get past sections that do validate certificates properly in order to reach the vulnerable code. This proves that it will accept certificates from any CA. You should always validate your configuration by visiting an HTTPS site in the native browser and verifying you receive a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, 1), (7, "ALLOW_ALL_HOSTNAME_VERIFIER invoked : org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER in /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This can allow for impromper x.509 certificate validation wherein the DNS hostname does not match the Common or Subject Alternative Name(s) on the certificate, making the application vulnerable to Man-In-The-Middle attacks. This means the application may potentially accept a certificate from any trusted CA, regardless of the domain it was issued for. The can be validated using the free version of Burpsuite by installing the Portswigger CA certificate, thereby making it a trusted CA on the device. Set the device network settings to use the Burpsuite proxy, then go Proxy > Options > Edit the Proxy Listener by changing the Certificate tab to Generate a CA-signed certificate with a specific hostname and enter a domain like foobar.com which doesn't match the domain name(s) the app is connecting to normally. You should always verify your results by visiting an https site in the native browser and confirming you see a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, '/Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java', '', 1), ("ALLOW_ALL_HOSTNAME_VERIFIER invoked : org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER in /Users/dhaugh/Documents/mobilevulnkit_trunk/mobilevulnkit/qark/test/testData/goatdroid/classes_dex2jar/org/owasp/goatdroid/fourgoats/requestresponse/CustomSSLSocketFactory.java. This can allow for impromper x.509 certificate validation wherein the DNS hostname does not match the Common or Subject Alternative Name(s) on the certificate, making the application vulnerable to Man-In-The-Middle attacks. This means the application may potentially accept a certificate from any trusted CA, regardless of the domain it was issued for. The can be validated using the free version of Burpsuite by installing the Portswigger CA certificate, thereby making it a trusted CA on the device. Set the device network settings to use the Burpsuite proxy, then go Proxy > Options > Edit the Proxy Listener by changing the Certificate tab to Generate a CA-signed certificate with a specific hostname and enter a domain like foobar.com which doesn't match the domain name(s) the app is connecting to normally. You should always verify your results by visiting an https site in the native browser and confirming you see a certificate warning. For details, please see: https://developer.android.com/training/articles/security-ssl.html", {}, 1), 'Some files may not be parsed correctly. For a list of such files, please review the final report.', 'Some files may not be parsed correctly. For a list of such files, please review the final report.']

def test_findBroadcasts():
    setup()

    output = Queue()
    findBroadcasts.main(output) #2nd var doesn't do anything
    fbOut = output.get()
    assert fbOut == []

if __name__ == '__main__':
    # test_filePermissions()
    test_webviews()

