/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VPath;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ParentVDir
extends BaseVDir {
    @CheckForNull
    protected final VDir parent;

    ParentVDir(@Nonnull BaseVFS<? extends BaseVDir, ? extends BaseVFile> vfs, @Nonnull String name) {
        super(vfs, name);
        this.parent = null;
    }

    ParentVDir(@Nonnull BaseVFS<? extends BaseVDir, ? extends BaseVFile> vfs, @Nonnull VDir parent, @Nonnull String name) {
        super(vfs, name);
        this.parent = parent;
    }

    @Override
    @Nonnull
    public VPath getPath() {
        if (this.parent != null) {
            return this.parent.getPath().clone().appendPath(new VPath(this.name, '/'));
        }
        return VPath.ROOT;
    }

    @CheckForNull
    VDir getParent() {
        return this.parent;
    }
}

