/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.AbstractVFS;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.GenericInputVDir;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class GenericInputVFS
extends AbstractVFS
implements InputVFS {
    @Nonnull
    final VFS vfs;

    public GenericInputVFS(@Nonnull VFS vfs) {
        this.vfs = vfs;
    }

    @Override
    @Nonnull
    public InputVDir getRootInputVDir() {
        return new GenericInputVDir(this.vfs.getRootDir());
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getLocation();
    }

    @Override
    public void close() throws CannotCloseException {
        this.vfs.close();
    }

    @Override
    public boolean isClosed() {
        return this.vfs.isClosed();
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return this.vfs.getDigest();
    }

    @Nonnull
    public VPath getPathFromRoot(@Nonnull InputVFile file) {
        return ((BaseVFS)this.vfs).getPathFromRoot((BaseVFile)file.getVFile());
    }

    @Override
    @Nonnull
    public String toString() {
        return "inputFS >> " + this.vfs.toString();
    }
}

