/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotListDirException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.ParentVDir;
import com.android.sched.vfs.ParentVFile;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DirectFS
extends BaseVFS<ParentVDir, ParentVFile>
implements VFS {
    @Nonnull
    private final Directory dir;
    @Nonnull
    private final ParentVDir root;
    @Nonnull
    private final Set<Capabilities> capabilities;
    @CheckForNull
    private String infoString;

    public DirectFS(@Nonnull Directory dir, int permissions) {
        this.dir = dir;
        this.root = new ParentVDir(this, "");
        EnumSet<Capabilities> capabilities = EnumSet.noneOf(Capabilities.class);
        if ((permissions & 1) != 0) {
            capabilities.add(Capabilities.READ);
            capabilities.add(Capabilities.PARALLEL_READ);
        }
        if ((permissions & 2) != 0) {
            capabilities.add(Capabilities.WRITE);
            capabilities.add(Capabilities.PARALLEL_WRITE);
        }
        this.capabilities = Collections.unmodifiableSet(capabilities);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "directory on disk";
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.dir.getLocation();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.dir.getPath();
    }

    @Override
    public ParentVDir getRootDir() {
        return this.root;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull ParentVFile file) throws WrongPermissionException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        VFSStatCategory.DIR_READ.getCounterStat(this.getTracer(), this.infoString).incValue();
        File path = this.getNativeFile(file.getPath());
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            FileOrDirectory.checkPermissions(path, file.getLocation(), 1);
            throw new ConcurrentIOException(e);
        }
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull ParentVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull ParentVFile file, boolean append) throws WrongPermissionException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.WRITE));
        VFSStatCategory.DIR_WRITE.getCounterStat(this.getTracer(), this.infoString).incValue();
        File path = this.getNativeFile(file.getPath());
        try {
            return new FileOutputStream(path, append);
        }
        catch (FileNotFoundException e) {
            FileOrDirectory.checkPermissions(path, file.getLocation(), 2);
            throw new ConcurrentIOException(e);
        }
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull ParentVDir dir) {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        File path = this.getNativeFile(dir.getPath());
        File[] subs = path.listFiles();
        if (subs == null) {
            throw new ConcurrentIOException(new CannotListDirException(new DirectoryLocation(path)));
        }
        if (subs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<BaseVElement> items = new ArrayList<BaseVElement>(subs.length);
        for (File sub : subs) {
            if (sub.isFile()) {
                items.add(new ParentVFile(this, dir, sub.getName()));
                continue;
            }
            items.add(new ParentVDir(this, dir, sub.getName()));
        }
        return items;
    }

    @Override
    boolean isEmpty(@Nonnull ParentVDir dir) {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        File[] fileList = this.getNativeFile(dir.getPath()).listFiles();
        assert (fileList != null);
        return fileList.length == 0;
    }

    @Override
    @Nonnull
    ParentVFile createVFile(@Nonnull ParentVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.WRITE));
        File path = this.getNativeFile(parent.getPath(), name);
        try {
            AbstractStreamFile.create(path, new FileLocation(path));
            VFSStatCategory.DIR_CREATE.getPercentStat(this.getTracer(), this.infoString).addTrue();
        }
        catch (FileAlreadyExistsException e) {
            VFSStatCategory.DIR_CREATE.getPercentStat(this.getTracer(), this.infoString).addFalse();
        }
        return new ParentVFile(this, parent, name);
    }

    @Override
    @Nonnull
    ParentVDir getVDir(@Nonnull ParentVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        File path = this.getNativeFile(parent.getPath(), name);
        Directory.check(path, new DirectoryLocation(path));
        return new ParentVDir(this, parent, name);
    }

    @Override
    @Nonnull
    ParentVFile getVFile(@Nonnull ParentVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        File path = this.getNativeFile(parent.getPath(), name);
        AbstractStreamFile.check(path, new FileLocation(path));
        return new ParentVFile(this, parent, name);
    }

    @Override
    @Nonnull
    void delete(@Nonnull ParentVFile file) throws CannotDeleteFileException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.WRITE));
        File path = this.getNativeFile(file.getPath());
        if (!path.delete() || path.exists()) {
            throw new CannotDeleteFileException(file);
        }
    }

    @Override
    @Nonnull
    ParentVDir createVDir(@Nonnull ParentVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.WRITE));
        File path = this.getNativeFile(parent.getPath(), name);
        try {
            Directory.create(path, new DirectoryLocation(path));
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        return new ParentVDir(this, parent, name);
    }

    @Override
    public boolean needsSequentialWriting() {
        return false;
    }

    @Override
    @Nonnull
    public FileTime getLastModified(@Nonnull ParentVFile file) throws CannotGetModificationTimeException {
        try {
            return Files.getLastModifiedTime(this.getNativeFile(file.getPath()).toPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CannotGetModificationTimeException(this, (Throwable)e);
        }
    }

    @Nonnull
    FileLocation getVFileLocation(@Nonnull ParentVFile file) {
        return new FileLocation(this.getNativeFile(file.getPath()));
    }

    @Nonnull
    FileLocation getVFileLocation(@Nonnull ParentVDir parent, @Nonnull String name) {
        return new FileLocation(this.getNativeFile(parent.getPath(), name));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(@Nonnull ParentVDir dir) {
        return new DirectoryLocation(this.getNativeFile(dir.getPath()));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(@Nonnull ParentVDir parent, @Nonnull String name) {
        return new DirectoryLocation(this.getNativeFile(parent.getPath(), name));
    }

    @Nonnull
    FileLocation getVFileLocation(ParentVDir parent, VPath path) {
        return new FileLocation(this.getNativeFile(parent.getPath().clone().appendPath(path)));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(ParentVDir parent, VPath path) {
        return new DirectoryLocation(this.getNativeFile(parent.getPath().clone().appendPath(path)));
    }

    @Nonnull
    private File getNativeFile(@Nonnull VPath path) {
        return new File(this.dir.getFile(), path.getPathAsString(File.separatorChar));
    }

    @Nonnull
    private File getNativeFile(@Nonnull VPath path, @Nonnull String name) {
        return new File(new File(this.dir.getFile(), path.getPathAsString(File.separatorChar)), name);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull ParentVDir parent, @Nonnull ParentVFile file) {
        StringBuffer path = DirectFS.getPathFromDirInternal(parent, (ParentVDir)file.getParent()).append(file.getName());
        return new VPath(path.toString(), '/');
    }

    @Nonnull
    private static StringBuffer getPathFromDirInternal(@Nonnull ParentVDir baseDir, @Nonnull ParentVDir currentDir) {
        if (baseDir == currentDir) {
            return new StringBuffer();
        }
        ParentVDir currentParent = (ParentVDir)currentDir.getParent();
        assert (currentParent != null);
        return DirectFS.getPathFromDirInternal(baseDir, currentParent).append(currentDir.getName()).append('/');
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot(@Nonnull ParentVFile file) {
        return this.getPathFromDir(this.root, file);
    }

    public void setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.infoString;
    }

    public String toString() {
        return "dirFS: " + this.getLocation().getDescription();
    }
}

