/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.watcher;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.stats.TypeSize;
import com.android.sched.util.log.stats.TypeSizeImpl;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class TypeSizeWatcher
implements ObjectWatcher<Object> {
    @Nonnull
    private static final StatisticId<TypeSize> SIZES = new StatisticId<TypeSize>("jack.allocation.type", "Type size", TypeSizeImpl.class, TypeSize.class);

    @Override
    public boolean notifyInstantiation(@Nonnull Object object, @Nonnegative long size, int count, @Nonnull EventType notUsed, @CheckForNull StackTraceElement site) {
        try {
            TracerFactory.getTracer().getStatistic(SIZES).recordType(size);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    @Nonnull
    public ObjectWatcher.Statistics addSample(@Nonnull Object node, @CheckForNull ObjectWatcher.Statistics raw, @Nonnull EventType type) {
        throw new AssertionError();
    }

    @ImplementationName(iface=WatcherInstaller.class, name="type-size", description="record type size")
    public static class AllocationWatcherInstaller
    implements WatcherInstaller {
        @Override
        public void install(@Nonnull Tracer tracer) {
            tracer.registerWatcher(Object.class, TypeSizeWatcher.class);
        }
    }

    static class Statistics
    implements ObjectWatcher.Statistics {
        Statistics() {
        }

        @Override
        public Iterator<Statistic> iterator() {
            throw new AssertionError();
        }
    }
}

