/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.watcher;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.stats.Sample;
import com.android.sched.util.log.stats.SampleImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ArrayListWatcher
implements ObjectWatcher<ArrayList<?>> {
    @CheckForNull
    private String eventTypeName = null;
    @Nonnull
    private static Field arrayRef;
    private int previousCapacity;
    private int previousUnused;

    @Override
    public boolean notifyInstantiation(@Nonnull ArrayList<?> list, @Nonnegative long size, int count, @Nonnull EventType type, @CheckForNull StackTraceElement site) {
        this.eventTypeName = type.getName();
        try {
            this.previousCapacity = ((Object[])arrayRef.get(list)).length;
            this.previousUnused = this.previousCapacity - list.size();
            return true;
        }
        catch (IllegalAccessException e) {
            LoggerFactory.getLogger().log(Level.WARNING, "Can not get ArrayList array", e);
            return false;
        }
    }

    @Override
    @Nonnull
    public ObjectWatcher.Statistics addSample(@Nonnull ArrayList<?> list, @CheckForNull ObjectWatcher.Statistics raw, @Nonnull EventType type) {
        Statistics statistics = (Statistics)raw;
        if (statistics == null) {
            statistics = new Statistics();
        }
        try {
            int capacity = ((Object[])arrayRef.get(list)).length;
            int unused = capacity - list.size();
            if (capacity - this.previousCapacity != 0) {
                statistics.increaseCapacity.add(capacity - this.previousCapacity, this.eventTypeName);
            }
            if (unused - this.previousUnused != 0) {
                statistics.increaseUnused.add(unused - this.previousUnused, this.eventTypeName);
            }
            statistics.unused.add(unused, this.eventTypeName);
            this.previousCapacity = capacity;
            this.previousUnused = unused;
        }
        catch (IllegalAccessException e) {
            LoggerFactory.getLogger().log(Level.WARNING, "Can not instanciate Watcher", e);
        }
        return statistics;
    }

    static {
        try {
            arrayRef = ArrayList.class.getDeclaredField("elementData");
            arrayRef.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LoggerFactory.getLogger().log(Level.WARNING, "Can not get 'elementData' reference on type ArrayList", e);
            throw new ExceptionInInitializerError(e);
        }
    }

    @ImplementationName(iface=WatcherInstaller.class, name="arraylist-capacity", description="record state of the array backed by ArrayList")
    public static class ArrayListWatcherInstaller
    implements WatcherInstaller {
        @Override
        public void install(@Nonnull Tracer tracer) {
            tracer.registerWatcher(ArrayList.class, ArrayListWatcher.class);
        }
    }

    static class Statistics
    implements ObjectWatcher.Statistics {
        @Nonnull
        private static final StatisticId<Sample> INCREASE_CAPACITY = new StatisticId<Sample>("sched.collection.arraylist.entry.increase", "Additional entries in the underlying arrays of ArrayList instances", SampleImpl.class, Sample.class);
        @Nonnull
        private static final StatisticId<Sample> INCREASE_UNUSED = new StatisticId<Sample>("sched.collection.arraylist.entry.unused.increase", "Additionnal unused entries in the underlying arrays of ArrayList instances", SampleImpl.class, Sample.class);
        @Nonnull
        private static final StatisticId<Sample> UNUSED = new StatisticId<Sample>("sched.collection.arraylist.entry.unused", "Unused entries in the underlying arrays of ArrayList instances", SampleImpl.class, Sample.class);
        @Nonnull
        private final Sample increaseCapacity = INCREASE_CAPACITY.newInstance();
        @Nonnull
        private final Sample increaseUnused = INCREASE_UNUSED.newInstance();
        @Nonnull
        private final Sample unused = UNUSED.newInstance();

        Statistics() {
        }

        @Override
        public Iterator<Statistic> iterator() {
            ArrayList<Sample> list = new ArrayList<Sample>(3);
            list.add(this.increaseCapacity);
            list.add(this.increaseUnused);
            list.add(this.unused);
            return list.iterator();
        }
    }
}

