/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class LogFormatter
extends SimpleFormatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @Nonnull
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");

    @Override
    public synchronized String format(@CheckForNull LogRecord record) {
        assert (record != null);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.append(TIME_FORMAT.format(new Date()));
        printWriter.append(": ");
        printWriter.append(record.getLevel().toString());
        printWriter.append(": ");
        String n = record.getLoggerName();
        printWriter.append(n != null ? n : "anonymous");
        printWriter.append(": ");
        printWriter.append(this.formatMessage(record));
        printWriter.append(LINE_SEPARATOR);
        Throwable t = record.getThrown();
        if (t != null) {
            t.printStackTrace(printWriter);
        }
        printWriter.flush();
        return stringWriter.toString();
    }
}

