/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class SchedIOException
extends Exception {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final Location location;
    @CheckForNull
    private final HasLocation locationProvider;

    @Nonnull
    protected abstract String createMessage(@Nonnull String var1);

    protected SchedIOException(@Nonnull Location location, @CheckForNull Throwable cause) {
        super("", cause);
        assert (location != null);
        this.location = location;
        this.locationProvider = null;
    }

    protected SchedIOException(@Nonnull HasLocation locationProvider, @CheckForNull Throwable cause) {
        super("", cause);
        assert (locationProvider != null);
        this.location = null;
        this.locationProvider = locationProvider;
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.createMessage(this.getLocation().getDescription());
    }

    @Nonnull
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.locationProvider != null) {
            return this.locationProvider.getLocation();
        }
        throw new AssertionError();
    }
}

