/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.StreamFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.file.ZipException;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InputZipFile
extends StreamFile {
    @Nonnull
    ZipFile zipFile;

    public InputZipFile(@Nonnull String path, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException, ZipException {
        this(new File(path), new FileLocation(path), hooks, existence, change);
    }

    public InputZipFile(@CheckForNull Directory workingDirectory, String path, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence mustExist, @Nonnull FileOrDirectory.ChangePermission change) throws NotFileException, FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, ZipException {
        this(InputZipFile.getFileFromWorkingDirectory(workingDirectory, path), new FileLocation(path), hooks, mustExist, change);
    }

    private InputZipFile(@Nonnull File file, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException, ZipException {
        super(file, location, hooks, existence, 1, change);
        this.zipFile = this.processZip(file);
    }

    @Nonnull
    private ZipFile processZip(@Nonnull File file) throws ZipException {
        try {
            return new ZipFile(file);
        }
        catch (java.util.zip.ZipException e) {
            throw new ZipException(this.getLocation(), e);
        }
        catch (IOException e) {
            throw new ConcurrentIOException(e);
        }
    }

    @Nonnull
    public ZipFile getZipFile() {
        this.clearRemover();
        return this.zipFile;
    }

    @Nonnull
    public String getName() {
        assert (this.file != null);
        return this.file.getName();
    }

    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        assert (this.file != null);
        try {
            return Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CannotGetModificationTimeException(this, (Throwable)e);
        }
    }
}

