/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.CannotListDirException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.location.DirectoryLocation;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class FileUtils {
    private FileUtils() {
    }

    @Nonnull
    public static String getFileSeparator() {
        String fileSeparator = System.getProperty("file.separator", "/");
        return fileSeparator;
    }

    @Nonnull
    public static File getWorkingDirectory() {
        String workingDirectoryPath = System.getProperty("user.dir");
        return new File(workingDirectoryPath);
    }

    public static void createIfNotExists(@Nonnull File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory \"" + directory.getPath() + "\"");
        }
    }

    public static void deleteDir(@Nonnull File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new AssertionError();
        }
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            throw new ConcurrentIOException(new CannotListDirException(new DirectoryLocation(dir)));
        }
        for (File sub : fileList) {
            FileUtils.deleteSubElement(sub);
        }
        if (!dir.delete()) {
            throw new IOException("Failed to delete directory '" + dir.getPath() + "'");
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void deleteSubElement(@Nonnull File dir) {
        if (dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            if (fileList == null) {
                throw new ConcurrentIOException(new CannotListDirException(new DirectoryLocation(dir)));
            }
            for (File sub : fileList) {
                FileUtils.deleteSubElement(sub);
            }
        }
        dir.delete();
    }
}

