/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.ListCodec;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.LongExpression;
import com.android.sched.util.config.id.PropertyId;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ListPropertyId<T>
extends PropertyId<List<T>> {
    public ListPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull StringCodec<T> parser) {
        super(name, description, new ListCodec<T>(parser));
    }

    @Override
    @Nonnull
    public ListPropertyId<T> addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> addDefaultValue(@Nonnull List<T> defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> setShutdownHook(@Nonnull PropertyId.ShutdownRunnable<List<T>> shutdownRunner) {
        super.setShutdownHook(shutdownRunner);
        return this;
    }

    @Override
    @Nonnull
    public ListPropertyId<T> removeShutdownHook() {
        super.removeShutdownHook();
        return this;
    }

    @Override
    @Nonnull
    public ListCodec<T> getCodec() {
        return (ListCodec)super.getCodec();
    }

    @Nonnull
    public ListPropertyId<T> on(@Nonnull String separator) {
        ((ListCodec)this.getCodec()).setSeparator(separator);
        return this;
    }

    @Nonnull
    public ListPropertyId<T> minElements(@Nonnegative int min) {
        ((ListCodec)this.getCodec()).setMin(min);
        return this;
    }

    @Nonnull
    public ListPropertyId<T> maxElements(@Nonnegative int max) {
        ((ListCodec)this.getCodec()).setMax(max);
        return this;
    }

    @Nonnull
    public BooleanExpression isEmpty() {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!ListPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(ListPropertyId.this);
                }
                return ((List)checker.parse(ListPropertyId.this)).isEmpty();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ListPropertyId.this.format(this.formatPropertyName(ListPropertyId.this), true);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ListPropertyId.this.format(this.formatPropertyName(checker, ListPropertyId.this), this.eval(checker));
                }
                catch (MissingPropertyException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotEmpty() {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!ListPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(ListPropertyId.this);
                }
                return !((List)checker.parse(ListPropertyId.this)).isEmpty();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ListPropertyId.this.format(this.formatPropertyName(ListPropertyId.this), false);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ListPropertyId.this.format(this.formatPropertyName(checker, ListPropertyId.this), !this.eval(checker));
                }
                catch (MissingPropertyException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public LongExpression getSize() {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!ListPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(ListPropertyId.this);
                }
                return ((List)checker.parse(ListPropertyId.this)).size();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return "number of elements of " + this.formatPropertyName(ListPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return "number of elements of " + this.formatPropertyName(checker, ListPropertyId.this);
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String str, boolean empty) {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        sb.append(" is ");
        if (!empty) {
            sb.append("not ");
        }
        sb.append("empty");
        return sb.toString();
    }
}

