/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.BooleanCodec;
import com.android.sched.util.codec.KeyValueCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import javax.annotation.Nonnull;

public class BooleanPropertyId
extends PropertyId<Boolean> {
    @Nonnull
    private static KeyValueCodec<Boolean> parser = new BooleanCodec();

    @Nonnull
    public static BooleanPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new BooleanPropertyId(name, description);
    }

    protected BooleanPropertyId(@Nonnull String name, @Nonnull String description) {
        super(name, description, parser);
    }

    @Nonnull
    public BooleanPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public BooleanPropertyId addDefaultValue(@Nonnull Boolean defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public BooleanPropertyId addDefaultValue(boolean defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public BooleanPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public BooleanExpression getValue() {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!BooleanPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(BooleanPropertyId.this);
                }
                return checker.parse(BooleanPropertyId.this);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return this.formatPropertyName(BooleanPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return this.formatPropertyName(checker, BooleanPropertyId.this);
            }
        };
    }

    @Nonnull
    public BooleanPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public BooleanPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

