/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.expression;

import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.expression.Expression;
import com.android.sched.util.config.expression.PropertyNotRequiredException;
import javax.annotation.Nonnull;

public abstract class BooleanExpression
extends Expression {
    public abstract boolean eval(@Nonnull ConfigChecker var1) throws PropertyIdException, PropertyNotRequiredException;

    @Nonnull
    public BooleanExpression isEqual(final @Nonnull BooleanExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return BooleanExpression.this.eval(checker) == right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.format(BooleanExpression.this.getDescription(), true, right.getDescription());
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return BooleanExpression.this.format(BooleanExpression.this.getCause(checker), this.eval(checker), right.getCause(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotEqual(final @Nonnull BooleanExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return BooleanExpression.this.eval(checker) != right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.format(BooleanExpression.this.getDescription(), false, right.getDescription());
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return BooleanExpression.this.format(BooleanExpression.this.getCause(checker), !this.eval(checker), right.getCause(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression or(final @Nonnull BooleanExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                try {
                    if (BooleanExpression.this.eval(checker)) {
                        return true;
                    }
                }
                catch (MissingPropertyException missingPropertyException) {
                    // empty catch block
                }
                return right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.getDescription() + " or " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    if (BooleanExpression.this.eval(checker)) {
                        return BooleanExpression.this.getCause(checker);
                    }
                }
                catch (PropertyNotRequiredException propertyNotRequiredException) {
                    // empty catch block
                }
                try {
                    if (right.eval(checker)) {
                        return right.getCause(checker);
                    }
                    return BooleanExpression.this.getCause(checker) + " and " + right.getCause(checker);
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression and(final @Nonnull BooleanExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return BooleanExpression.this.eval(checker) && right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.getDescription() + " and " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    if (BooleanExpression.this.eval(checker) && right.eval(checker)) {
                        return BooleanExpression.this.getCause(checker) + " and " + right.getCause(checker);
                    }
                    if (!BooleanExpression.this.eval(checker)) {
                        return BooleanExpression.this.getCause(checker);
                    }
                    return right.getCause(checker);
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isTrue() {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return BooleanExpression.this.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.format(BooleanExpression.this.getDescription(), true);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return BooleanExpression.this.format(BooleanExpression.this.getCause(checker), this.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isFalse() {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return !BooleanExpression.this.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return BooleanExpression.this.format(BooleanExpression.this.getDescription(), false);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return BooleanExpression.this.format(BooleanExpression.this.getCause(checker), !this.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean equal, @Nonnull String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is ");
        if (!equal) {
            sb.append("not ");
        }
        sb.append("equal to ");
        sb.append(right);
        return sb.toString();
    }

    @Nonnull
    private String format(@Nonnull String left, boolean eval) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is set to ");
        sb.append(eval ? "true" : "false");
        return sb.toString();
    }
}

