/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.OutputVFSCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.GenericOutputVFS;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.WriteZipFS;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ZipOutputVFSCodec
extends OutputVFSCodec {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    private String infoString;

    public ZipOutputVFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a zip archive (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "zip";
    }

    @Override
    @Nonnull
    public OutputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        RunnableHooks hooks = context.getRunnableHooks();
        try {
            WriteZipFS vfs = new WriteZipFS(new OutputZipFile(context.getWorkingDirectory(), string, hooks, this.existence, this.change, OutputZipFile.Compression.COMPRESSED));
            vfs.setInfoString(this.infoString);
            return new GenericOutputVFS(vfs);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Nonnull
    public ZipOutputVFSCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

