/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.file.FileOrDirectory;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PathCodec
implements StringCodec<File> {
    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a file or directory";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "path";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @CheckForNull
    public File checkString(@Nonnull CodecContext context, @Nonnull String value) {
        return null;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull File file) {
    }

    @Override
    @Nonnull
    public File parseString(@Nonnull CodecContext context, @Nonnull String value) {
        return FileOrDirectory.getFileFromWorkingDirectory(context.getWorkingDirectory(), value);
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull File file) {
        return file.getPath();
    }
}

