/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class KeyValueCodec<T>
implements StringCodec<T> {
    private boolean ignoreCase = false;
    private boolean sorted = false;
    @Nonnull
    private Entry<T>[] entries;
    @CheckForNull
    private List<Parser.ValueDescription> descriptions;
    @Nonnull
    private final String varName;

    public KeyValueCodec(@Nonnull String varName, @Nonnull Entry<T>[] entries) {
        this.entries = Arrays.copyOf(entries, entries.length);
        this.varName = varName;
    }

    protected void setElements(@Nonnull Entry<T>[] entries) {
        this.entries = Arrays.copyOf(entries, entries.length);
        if (this.ignoreCase) {
            this.ignoreCase();
        }
        if (this.sorted) {
            this.sorted();
        }
    }

    @Nonnull
    public KeyValueCodec<T> ignoreCase() {
        this.ignoreCase = true;
        for (int idx = 0; idx < this.entries.length; ++idx) {
            this.entries[idx].key = this.entries[idx].key.toLowerCase();
        }
        return this;
    }

    @Nonnull
    public KeyValueCodec<T> sorted() {
        this.sorted = true;
        Arrays.sort(this.entries, new Comparator<Entry<T>>(){

            @Override
            public int compare(Entry<T> o1, Entry<T> o2) {
                return o1.key.compareToIgnoreCase(o2.key);
            }
        });
        return this;
    }

    @Override
    @Nonnull
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('{');
        for (Entry<T> entry : this.entries) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.key);
        }
        sb.append("} (case ");
        sb.append(this.ignoreCase ? "insensitive" : "sensitive");
        sb.append(')');
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.varName;
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Parser.ValueDescription>(this.entries.length);
            for (Entry<T> entry : this.entries) {
                if (entry.description == null) continue;
                this.descriptions.add(new Parser.ValueDescription(entry.key, entry.description));
            }
        }
        assert (this.descriptions != null);
        return this.descriptions;
    }

    @Override
    @Nonnull
    public T checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        for (Entry<T> entry : this.entries) {
            if (!entry.key.equals(string)) continue;
            return entry.value;
        }
        throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull T value) throws CheckingException {
        for (Entry<T> entry : this.entries) {
            if (!entry.value.equals(value)) continue;
            return;
        }
        HashSet set = new HashSet();
        for (Entry<T> entry : this.entries) {
            set.add(entry.value);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object data : set) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(data);
            sb.append(" (");
            sb.append(data.getClass().getCanonicalName());
            sb.append(')');
        }
        throw new CheckingException("The value must be {" + sb.toString() + "} but is '" + value.toString() + " (" + value.getClass().getCanonicalName() + ")'");
    }

    @Override
    @Nonnull
    public T parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull T value) {
        for (Entry<T> entry : this.entries) {
            if (entry.value != value) continue;
            return entry.key;
        }
        throw new AssertionError();
    }

    public static class Entry<T> {
        @Nonnull
        String key;
        @Nonnull
        T value;
        @CheckForNull
        String description;

        public Entry(@Nonnull String key, @Nonnull T value) {
            this.key = key;
            this.value = value;
        }

        public Entry(@Nonnull String key, @Nonnull T value, @CheckForNull String description) {
            this.key = key;
            this.value = value;
            if (description != null && !description.isEmpty()) {
                this.description = description;
            }
        }
    }
}

