/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class IntCodec
implements StringCodec<Integer> {
    private int min;
    private int max;

    public IntCodec() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntCodec(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = this.min;
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "an integer belonging to [" + this.min + " .. " + this.max + "]";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "number";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Integer checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            Integer i = Integer.valueOf(string);
            try {
                this.checkValue(context, i);
            }
            catch (CheckingException e) {
                throw new ParsingException(e);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Integer i) throws CheckingException {
        int v = i;
        if (v < this.min || v > this.max) {
            throw new CheckingException("The value must be " + this.getUsage() + " but is " + i);
        }
    }

    @Override
    @Nonnull
    public Integer parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Integer i) {
        return i.toString();
    }
}

