/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.vfs.InputOutputVFS;
import javax.annotation.Nonnull;

abstract class InputOutputVFSCodec
extends FileOrDirCodec<InputOutputVFS> {
    public InputOutputVFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence, 3);
    }

    @Nonnull
    public InputOutputVFSCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public InputOutputVFSCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputOutputVFS dir) {
    }

    @Override
    @Nonnull
    public InputOutputVFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return (InputOutputVFS)this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputOutputVFS directory) {
        return directory.getPath();
    }
}

