/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.file.FileOrDirectory;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class FileOrDirCodec<T>
implements StringCodec<T> {
    @Nonnull
    protected FileOrDirectory.ChangePermission change = FileOrDirectory.ChangePermission.NOCHANGE;
    protected final int permissions;
    @Nonnull
    protected FileOrDirectory.Existence existence;

    protected FileOrDirCodec(@Nonnull FileOrDirectory.Existence existence, int permissions) {
        assert (permissions != 0) : "At least one permission must be defined";
        this.permissions = permissions;
        this.existence = existence;
    }

    protected void setChangePermission(@Nonnull FileOrDirectory.ChangePermission change) {
        this.change = change;
    }

    @Nonnull
    public String getDetailedUsage() {
        StringBuilderAppender sb = new StringBuilderAppender(", ");
        sb.append("must ");
        sb.append(this.existence == FileOrDirectory.Existence.MUST_EXIST, "exist");
        sb.append(this.existence == FileOrDirectory.Existence.NOT_EXIST, "not exist");
        sb.append((this.permissions & 1) != 0, "be readable");
        sb.append((this.permissions & 2) != 0, "be writable");
        sb.append((this.permissions & 4) != 0, "be executable");
        return sb.toString();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    protected static class StringBuilderAppender {
        private boolean needSeparator = false;
        @Nonnull
        private final StringBuilder sb = new StringBuilder();
        @Nonnull
        private final String separator;

        StringBuilderAppender(@Nonnull String separator) {
            this.separator = separator;
        }

        @Nonnull
        public StringBuilderAppender append(@Nonnull String string) {
            this.needSeparator = false;
            this.sb.append(string);
            return this;
        }

        @Nonnull
        public StringBuilderAppender append(boolean condition, @Nonnull String string) {
            if (condition) {
                if (this.needSeparator) {
                    this.sb.append(this.separator);
                }
                this.needSeparator = true;
                this.sb.append(string);
            }
            return this;
        }

        @Nonnull
        public String toString() {
            return this.sb.toString();
        }
    }
}

