/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.InputOutputVFSCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.CachedDirectFS;
import com.android.sched.vfs.GenericInputOutputVFS;
import com.android.sched.vfs.InputOutputVFS;
import javax.annotation.Nonnull;

public class DirectDirInputOutputVFSCodec
extends InputOutputVFSCodec
implements StringCodec<InputOutputVFS> {
    public DirectDirInputOutputVFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "dir";
    }

    @Override
    @Nonnull
    public InputOutputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            return new GenericInputOutputVFS(new CachedDirectFS(new Directory(context.getWorkingDirectory(), string, context.getRunnableHooks(), this.existence, this.permissions, this.change), this.permissions));
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new ParsingException(e);
        }
    }
}

