/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;

class RemoveRunnerMutation<T extends Component>
implements EvolutionaryOperator<GroupPlanCandidate<T>> {
    @Nonnull
    private final NumberGenerator<Probability> removeProbability;

    public RemoveRunnerMutation(@Nonnull NumberGenerator<Probability> removeProbability, @Nonnull Request request, @Nonnull Class<? extends Component> runOn) {
        this.removeProbability = removeProbability;
    }

    @Override
    @Nonnull
    public List<GroupPlanCandidate<T>> apply(List<GroupPlanCandidate<T>> selectedCandidates, Random rng) {
        ArrayList<GroupPlanCandidate<T>> mutatedCandidates = new ArrayList<GroupPlanCandidate<T>>(selectedCandidates.size());
        for (GroupPlanCandidate<T> candidate : selectedCandidates) {
            if (candidate.getSize() != 0 && this.removeProbability.nextValue().nextEvent(rng)) {
                int victim;
                ArrayList<ManagedRunnable> newRunners = new ArrayList<ManagedRunnable>(candidate.getRunnables());
                if (((ManagedRunnable)newRunners.get(victim = rng.nextInt(newRunners.size()))).getProductions().isEmpty()) {
                    newRunners.remove(victim);
                }
                mutatedCandidates.add(new GroupPlanCandidate<T>(candidate, newRunners));
                continue;
            }
            mutatedCandidates.add(candidate);
        }
        return mutatedCandidates;
    }
}

