/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanPrinter;
import com.android.sched.scheduler.PlanPrinterFactory;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@ImplementationName(iface=PlanPrinter.class, name="simple-txt")
public class SimpleTextPlanPrinter
implements PlanPrinter {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final WriterFile planFile = ThreadConfig.get(PlanPrinterFactory.PLAN_PRINTER_FILE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPlan(@Nonnull Plan<?> plan) throws CannotWriteException {
        CustomPrintWriter writer = this.planFile.getPrintWriter();
        try {
            writer.println(plan.getDescription());
        }
        finally {
            writer.close();
            try {
                writer.throwPendingException();
            }
            catch (IOException e) {
                throw new CannotWriteException(this.planFile.getLocation(), (Throwable)e);
            }
        }
    }
}

