/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.marker;

import com.android.sched.item.Description;
import com.android.sched.item.Items;
import com.android.sched.marker.DynamicValidOn;
import com.android.sched.marker.Marker;
import com.android.sched.marker.MarkerManager;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.marker.ValidOn;
import com.android.sched.util.HasDescription;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ManagedMarker
implements HasDescription {
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final String name;
    @Nonnull
    private final String description;
    @Nonnull
    private final Class<? extends Marker> marker;
    @Nonnull
    private Class<? extends MarkerManager>[] staticValidOn;
    @Nonnull
    private List<InternalDynamicValidOn> dynamicValidOn;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public ManagedMarker(@Nonnull Class<? extends Marker> marker) throws MarkerNotConformException {
        this.marker = marker;
        this.name = Items.getName(marker);
        String description = Items.getDescription(marker);
        if (description == null) {
            throw new MarkerNotConformException("Marker '" + marker.getCanonicalName() + "' must have a @" + Description.class.getSimpleName());
        }
        this.description = description;
        this.extractAnnotation(marker);
        logger.log(Level.CONFIG, "{0}", this);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Class<? extends MarkerManager>[] getStaticValidOn() {
        return (Class[])this.staticValidOn.clone();
    }

    @Nonnull
    public List<InternalDynamicValidOn> getDynamicValidOn() {
        return this.dynamicValidOn;
    }

    public boolean isValidMarker(@Nonnull MarkerManager marked) {
        for (Class<? extends MarkerManager> cls : this.staticValidOn) {
            if (!cls.isAssignableFrom(marked.getClass())) continue;
            return true;
        }
        for (InternalDynamicValidOn dvo : this.dynamicValidOn) {
            if (!dvo.validOn.isAssignableFrom(marked.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidMarker(@Nonnull MarkerManager marked, @Nonnull Marker m) {
        for (Class<? extends MarkerManager> cls : this.staticValidOn) {
            if (!cls.isAssignableFrom(marked.getClass())) continue;
            return true;
        }
        for (InternalDynamicValidOn dvo : this.dynamicValidOn) {
            if (!dvo.validOn.isAssignableFrom(marked.getClass())) continue;
            try {
                return (Boolean)dvo.method.invoke((Object)m, marked);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "Program can not be here", e);
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "Program can not be here", e);
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.WARNING, "Method '" + dvo.method.toString() + "' threw an exception", e.getCause());
                return false;
            }
        }
        return false;
    }

    @Nonnull
    public Class<? extends Marker> getMarker() {
        return this.marker;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Marker '");
        sb.append(this.name);
        sb.append("' (");
        sb.append(this.description);
        sb.append("), static valid on [");
        boolean first = true;
        for (Class<? extends MarkerManager> cls : this.staticValidOn) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(cls.getCanonicalName());
        }
        sb.append("], dynamic valid on [");
        first = true;
        for (InternalDynamicValidOn dvo : this.dynamicValidOn) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(dvo.validOn.getCanonicalName());
            sb.append(" (");
            sb.append(dvo.method);
            sb.append(")");
        }
        sb.append(']');
        return new String(sb);
    }

    private void extractAnnotation(@Nonnull Class<? extends Marker> m) {
        ValidOn validOnAnnotation = m.getAnnotation(ValidOn.class);
        if (validOnAnnotation != null) {
            if (validOnAnnotation.value().length == 0) {
                throw new MarkerNotConformException("Annotation @" + ValidOn.class.getSimpleName() + " on class '" + m.getCanonicalName() + "' must have at least one parameter");
            }
            this.staticValidOn = validOnAnnotation.value();
        } else {
            this.staticValidOn = new Class[0];
        }
        this.dynamicValidOn = new ArrayList<InternalDynamicValidOn>();
        for (Method method : m.getMethods()) {
            DynamicValidOn dynamicValidOnAnnotation = method.getAnnotation(DynamicValidOn.class);
            if (dynamicValidOnAnnotation == null) continue;
            if (!method.getReturnType().equals(Boolean.TYPE)) {
                throw new MarkerNotConformException("Annotated method '" + method.toString() + "' with @" + DynamicValidOn.class.getSimpleName() + " must have a 'boolean' return type");
            }
            if (method.getParameterTypes().length != 1) {
                throw new MarkerNotConformException("Annotated method '" + method.toString() + "' with @" + DynamicValidOn.class.getSimpleName() + " must have a single parameter");
            }
            if (!MarkerManager.class.isAssignableFrom(method.getParameterTypes()[0])) {
                throw new MarkerNotConformException("Annotated method '" + method.toString() + "' with @" + DynamicValidOn.class.getSimpleName() + " must have a parameter assignable from " + MarkerManager.class.getSimpleName());
            }
            for (Class<? extends MarkerManager> marked : this.staticValidOn) {
                if (!marked.isAssignableFrom(method.getParameterTypes()[0])) continue;
                throw new MarkerNotConformException("Marker '" + this.name + "' cannot have both a static @" + ValidOn.class.getName() + " (on class '" + this.marker.getCanonicalName() + "') and a @" + DynamicValidOn.class.getName() + " (on method '" + method.toString() + "'");
            }
            for (InternalDynamicValidOn dvo : this.dynamicValidOn) {
                if (!dvo.validOn.isAssignableFrom(method.getParameterTypes()[0]) && !method.getParameterTypes()[0].isAssignableFrom(dvo.validOn)) continue;
                throw new MarkerNotConformException("Marker '" + this.name + "' cannot have two @" + DynamicValidOn.class.getName() + " ('" + method.toString() + "' and '" + dvo.method.toString() + "')");
            }
            InternalDynamicValidOn dvo = new InternalDynamicValidOn();
            dvo.validOn = method.getParameterTypes()[0];
            dvo.method = method;
            this.dynamicValidOn.add(dvo);
        }
    }

    public static class InternalDynamicValidOn {
        private Class<? extends MarkerManager> validOn;
        private Method method;

        public Class<? extends MarkerManager> getValidOn() {
            return this.validOn;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.validOn);
            sb.append(" ('");
            sb.append(this.method);
            sb.append("')");
            return new String(sb);
        }
    }
}

