/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.marker;

import com.android.sched.item.Items;
import com.android.sched.marker.AbstractMarkerManager;
import com.android.sched.marker.Marker;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class LocalMarkerManager
extends AbstractMarkerManager {
    @Nonnull
    private static final Collection<Marker> EMPTY_MARKER = Collections.emptyList();
    @CheckForNull
    private ConcurrentHashMap<Class<? extends Marker>, Marker> markers;
    @Nonnull
    private final Object lock = new Object();

    @Override
    public <T extends Marker> T addMarker(@Nonnull T marker) {
        assert (this.isValidMarker(marker)) : "Marker '" + Items.getName(marker.getClass()) + "' is not supported for class '" + this.getClass().getName() + "'";
        this.ensureMap();
        assert (this.markers != null);
        return (T)this.markers.put(marker.getClass(), marker);
    }

    @Override
    public void addAllMarkers(@Nonnull Collection<Marker> collection) {
        this.ensureMap();
        for (Marker marker : collection) {
            assert (this.isValidMarker(marker)) : "Marker '" + Items.getName(marker.getClass()) + "' is not supported for class '" + this.getClass().getName() + "'";
            assert (this.markers != null);
            this.markers.put(marker.getClass(), marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Collection<Marker> getAllMarkers() {
        Iterator<Marker> iterator = this.lock;
        synchronized (iterator) {
            if (this.markers == null) {
                return EMPTY_MARKER;
            }
        }
        for (Marker marker : this.markers.values()) {
            assert (this.checkGetAccess(marker.getClass()));
        }
        assert (this.markers != null);
        return this.markers.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public <T extends Marker> T getMarker(@Nonnull Class<T> cls) {
        Object object = this.lock;
        synchronized (object) {
            if (this.markers == null) {
                return null;
            }
        }
        return (T)this.markers.get(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Marker> boolean containsMarker(@Nonnull Class<T> cls) {
        assert (this.isValidMarker(cls)) : "Marker '" + Items.getName(cls) + "' is not supported for class '" + this.getClass().getName() + "'";
        Object object = this.lock;
        synchronized (object) {
            if (this.markers == null) {
                return false;
            }
        }
        return this.markers.containsKey(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T extends Marker> T getMarkerOrDefault(@Nonnull T defaultMarker) {
        assert (this.isValidMarker(defaultMarker)) : "Marker '" + Items.getName(defaultMarker.getClass()) + "' is not supported for class '" + this.getClass().getName() + "'";
        Object object = this.lock;
        synchronized (object) {
            if (this.markers == null) {
                return defaultMarker;
            }
        }
        Marker marker = this.markers.get(defaultMarker.getClass());
        if (marker == null) {
            return defaultMarker;
        }
        return (T)marker;
    }

    @Override
    @CheckForNull
    public <T extends Marker> T addMarkerIfAbsent(@Nonnull T newMarker) {
        assert (this.isValidMarker(newMarker)) : "Marker '" + Items.getName(newMarker.getClass()) + "' is not supported for class '" + this.getClass().getName() + "'";
        this.ensureMap();
        assert (this.markers != null);
        return (T)this.markers.putIfAbsent(newMarker.getClass(), newMarker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public <T extends Marker> T removeMarker(@Nonnull Class<T> cls) {
        Object object = this.lock;
        synchronized (object) {
            if (this.markers == null) {
                return null;
            }
        }
        return (T)this.markers.remove(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.markers == null) {
                this.markers = new ConcurrentHashMap();
            }
        }
    }
}

