/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import java.text.ParseException;
import javax.annotation.Nonnull;

public class StringUtils {
    @Nonnull
    public static String utf8BytesToString(@Nonnull byte[] bytes) throws ParseException {
        int length = bytes.length;
        char[] chars = new char[length];
        int outAt = 0;
        int at = 0;
        while (length > 0) {
            char out;
            int v0 = 0xFF & bytes[at];
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v0 == 0) {
                        throw new ParseException("Invalid string value", at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        throw new ParseException("Invalid string value", at);
                    }
                    int v1 = 0xFF & bytes[at + 1];
                    if ((v1 & 0xC0) != 128) {
                        throw new ParseException("Invalid string value", at);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        throw new ParseException("Invalid string value", at);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        throw new ParseException("Invalid string value", at);
                    }
                    int v1 = 0xFF & bytes[at + 1];
                    if ((v1 & 0xC0) != 128) {
                        throw new ParseException("Invalid string value", at);
                    }
                    int v2 = 0xFF & bytes[at + 2];
                    if ((v1 & 0xC0) != 128) {
                        throw new ParseException("Invalid string value", at);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        throw new ParseException("Invalid string value", at);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    throw new ParseException("Invalid string value", at);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    @Nonnull
    public static byte[] stringToUtf8Bytes(@Nonnull String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                bytes[outAt] = (byte)c;
                ++outAt;
                continue;
            }
            if (c < '\u0800') {
                bytes[outAt] = (byte)(c >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }
}

