/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.base.Splitter;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MethodNameCodec
implements StringCodec<MethodNameValue> {
    @Nonnull
    private final Splitter splitter = Splitter.on(".");
    @Nonnull
    private static final String CLASS_METHOD_SEPARATOR = "#";
    @Nonnull
    private static final String PACKAGE_SEPARATOR = ".";
    @Nonnull
    private static final String USAGE = "a fully qualified java method name (e.g. " + Joiner.on(".").join("java", "lang", "Object").toString() + "#" + "toString)";
    @Nonnull
    private static final String MESSAGE = "The value must be " + USAGE + " but ";

    @Override
    @Nonnull
    public String getUsage() {
        return USAGE;
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "method";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public MethodNameValue parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public MethodNameValue checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        String name;
        int idx = (string = string.trim()).indexOf(CLASS_METHOD_SEPARATOR);
        if (idx < 0) {
            throw new ParsingException(MESSAGE + "has no '" + CLASS_METHOD_SEPARATOR + "'");
        }
        String className = string.substring(0, idx);
        List<String> parts = this.splitter.splitToList(className);
        if (parts.isEmpty()) {
            throw new ParsingException(MESSAGE + "class name is empty");
        }
        for (int i = 0; i < parts.size() - 1; ++i) {
            name = parts.get(i);
            if (name.isEmpty()) {
                throw new ParsingException(MESSAGE + "package #" + (i + 1) + " name is empty");
            }
            if (this.isJavaValidIdentifier(parts.get(i))) continue;
            throw new ParsingException(MESSAGE + "package #" + (i + 1) + " name '" + name + "' is not a valid Java identifier");
        }
        name = parts.get(parts.size() - 1);
        if (name.isEmpty()) {
            throw new ParsingException(MESSAGE + "class name is empty");
        }
        if (!this.isJavaValidIdentifier(name)) {
            throw new ParsingException(MESSAGE + "class name '" + name + "' is not a valid Java identifier");
        }
        String methodName = string.substring(idx + 1, string.length());
        if (methodName.indexOf(CLASS_METHOD_SEPARATOR) >= 0) {
            throw new ParsingException(MESSAGE + "has several '" + CLASS_METHOD_SEPARATOR + "'");
        }
        if (methodName.isEmpty()) {
            throw new ParsingException(MESSAGE + "method name is empty");
        }
        if (!this.isJavaValidIdentifier(methodName)) {
            throw new ParsingException(MESSAGE + "method name '" + methodName + "' is not a valid Java identifier");
        }
        return new MethodNameValue(className, methodName);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull MethodNameValue data) {
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull MethodNameValue name) {
        return name.getFullName();
    }

    private boolean isJavaValidIdentifier(@Nonnull String id) {
        assert (id.length() > 0);
        char[] chars = id.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static final class MethodNameValue {
        @Nonnull
        private final String className;
        @Nonnull
        private final String methodName;

        private MethodNameValue(@Nonnull String className, @Nonnull String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Nonnull
        public String getClassName() {
            return this.className;
        }

        @Nonnull
        public String getMethodName() {
            return this.methodName;
        }

        @Nonnull
        public String getFullName() {
            return this.className + '#' + this.methodName;
        }
    }
}

