/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JTryStatement;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ControlFlowHelper {
    @CheckForNull
    public static JStatement getConcreteStatement(@Nonnull JStatementList block) {
        List<JStatement> statements = block.getStatements();
        if (statements.isEmpty()) {
            return ControlFlowHelper.getNextStatement(block);
        }
        JStatement firstStmt = statements.get(0);
        if (firstStmt instanceof JBlock) {
            return ControlFlowHelper.getConcreteStatement((JBlock)firstStmt);
        }
        if (firstStmt instanceof JLabeledStatement) {
            return ControlFlowHelper.getConcreteStatement((JBlock)((JLabeledStatement)firstStmt).getBody());
        }
        if (firstStmt instanceof JTryStatement) {
            return ControlFlowHelper.getConcreteStatement(((JTryStatement)firstStmt).getTryBlock());
        }
        return firstStmt;
    }

    @CheckForNull
    public static JStatement getNextStatement(@Nonnull JStatement statement) {
        JStatement nextStmt = null;
        JNode parent = statement.getParent();
        if (parent instanceof JMethodBody) {
            return null;
        }
        JStatement parentStmt = (JStatement)parent;
        if (parentStmt instanceof JStatementList) {
            List<JStatement> stmts = ((JStatementList)parentStmt).getStatements();
            int stmtPosition = stmts.indexOf(statement);
            int nextStmtPosition = stmtPosition + 1;
            nextStmt = nextStmtPosition >= stmts.size() ? ControlFlowHelper.getNextStatement(parentStmt) : stmts.get(nextStmtPosition);
        } else if (parentStmt instanceof JLabeledStatement || parentStmt instanceof JIfStatement || parentStmt instanceof JSwitchStatement || parentStmt instanceof JTryStatement) {
            nextStmt = ControlFlowHelper.getNextStatement(parentStmt);
        } else {
            throw new AssertionError();
        }
        if (nextStmt instanceof JCatchBlock) {
            nextStmt = ControlFlowHelper.getNextStatement(nextStmt);
        }
        return nextStmt;
    }

    @Nonnull
    public static BasicBlock getBasicBlock(@Nonnull JStatement stmt) {
        BasicBlockMarker bbm = stmt.getMarker(BasicBlockMarker.class);
        assert (bbm != null);
        return bbm.getBasicBlock();
    }
}

