/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.termination;

import com.android.jack.uncommons.watchmaker.framework.PopulationData;
import com.android.jack.uncommons.watchmaker.framework.TerminationCondition;

public class Stagnation
implements TerminationCondition {
    private final int generationLimit;
    private final boolean naturalFitness;
    private final boolean usePopulationAverage;
    private double bestFitness;
    private int fittestGeneration;

    public Stagnation(int generationLimit, boolean naturalFitness) {
        this(generationLimit, naturalFitness, false);
    }

    public Stagnation(int generationLimit, boolean naturalFitness, boolean usePopulationAverage) {
        this.generationLimit = generationLimit;
        this.naturalFitness = naturalFitness;
        this.usePopulationAverage = usePopulationAverage;
    }

    @Override
    public boolean shouldTerminate(PopulationData<?> populationData) {
        double fitness = this.getFitness(populationData);
        if (populationData.getGenerationNumber() == 0 || this.hasFitnessImproved(fitness)) {
            this.bestFitness = fitness;
            this.fittestGeneration = populationData.getGenerationNumber();
        }
        return populationData.getGenerationNumber() - this.fittestGeneration >= this.generationLimit;
    }

    private double getFitness(PopulationData<?> populationData) {
        return this.usePopulationAverage ? populationData.getMeanFitness() : populationData.getBestCandidateFitness();
    }

    private boolean hasFitnessImproved(double fitness) {
        return this.naturalFitness && fitness > this.bestFitness || !this.naturalFitness && fitness < this.bestFitness;
    }
}

