/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.binary.BitString;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.operators.AbstractCrossover;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BitStringCrossover
extends AbstractCrossover<BitString> {
    public BitStringCrossover() {
        this(1);
    }

    public BitStringCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public BitStringCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public BitStringCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public BitStringCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<BitString> mate(BitString parent1, BitString parent2, int numberOfCrossoverPoints, Random rng) {
        if (parent1.getLength() != parent2.getLength()) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        BitString offspring1 = parent1.clone();
        BitString offspring2 = parent2.clone();
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.getLength() - 1);
            offspring1.swapSubstring(offspring2, 0, crossoverIndex);
        }
        ArrayList<BitString> result = new ArrayList<BitString>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }
}

