/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.interactive;

import com.android.jack.uncommons.util.reflection.ReflectionUtils;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import com.android.jack.uncommons.watchmaker.framework.interactive.Console;
import com.android.jack.uncommons.watchmaker.framework.interactive.Renderer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class InteractiveSelection<T>
implements SelectionStrategy<T> {
    private final Console<?> console;
    private final Renderer<T, ?> renderer;
    private final int groupSize;
    private final int maxSelectionsPerGeneration;

    public <R> InteractiveSelection(Console<R> console, Renderer<T, R> renderer, int groupSize, int maxSelectionsPerGeneration) {
        if (groupSize < 2) {
            throw new IllegalArgumentException("Group size must be at least 2.");
        }
        if (maxSelectionsPerGeneration < 1) {
            throw new IllegalArgumentException("Maximum selections must be 1 or more.");
        }
        this.console = console;
        this.renderer = renderer;
        this.groupSize = groupSize;
        this.maxSelectionsPerGeneration = maxSelectionsPerGeneration;
    }

    public InteractiveSelection(Console<T> console, int groupSize, int maxSelectionsPerGeneration) {
        this(console, new NoOpRenderer(), groupSize, maxSelectionsPerGeneration);
    }

    @Override
    public <S extends T> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        if (population.size() < this.groupSize) {
            throw new IllegalArgumentException("Population is too small for selection group size of " + this.groupSize);
        }
        int selectionCount = Math.min(selectionSize, this.maxSelectionsPerGeneration);
        ArrayList selection = new ArrayList(selectionCount);
        for (int i = 0; i < selectionCount; ++i) {
            ArrayList group = new ArrayList(this.groupSize);
            ArrayList<EvaluatedCandidate<S>> candidates = new ArrayList<EvaluatedCandidate<S>>(population);
            Collections.shuffle(candidates);
            for (int j = 0; j < this.groupSize; ++j) {
                group.add(((EvaluatedCandidate)candidates.get(j)).getCandidate());
            }
            selection.add(this.select(group));
        }
        if (selectionCount < selectionSize) {
            ArrayList extendedSelection = new ArrayList(selectionSize);
            extendedSelection.addAll(selection);
            for (int i = 0; i < selectionSize - selectionCount; ++i) {
                extendedSelection.add(selection.get(selectionCount == 1 ? 0 : rng.nextInt(selectionCount)));
            }
            return extendedSelection;
        }
        return selection;
    }

    private <S extends T> S select(List<S> candidates) {
        ArrayList renderedCandidates = new ArrayList(candidates.size());
        for (S candidate : candidates) {
            renderedCandidates.add(this.renderer.render(candidate));
        }
        Method consoleSelectMethod = ReflectionUtils.findKnownMethod(Console.class, "select", List.class);
        Integer selection = (Integer)ReflectionUtils.invokeUnchecked(consoleSelectMethod, this.console, renderedCandidates);
        return candidates.get(selection);
    }

    private static final class NoOpRenderer<T>
    implements Renderer<T, T> {
        private NoOpRenderer() {
        }

        @Override
        public T render(T entity) {
            return entity;
        }
    }
}

