/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.util.id;

import com.android.jack.uncommons.util.id.IDSource;
import com.android.jack.uncommons.util.id.IntSequenceIDSource;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class CompositeIDSource
implements IDSource<Long> {
    private final Lock lock = new ReentrantLock();
    private final long top32bits;
    private final IDSource<Integer> sequence = new IntSequenceIDSource();

    public CompositeIDSource(int topPart) {
        this.top32bits = (long)topPart << 32;
    }

    @Override
    public Long nextID() {
        this.lock.lock();
        try {
            Long l = this.top32bits + (long)this.sequence.nextID().intValue();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

