/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.random.SeedException;
import com.android.jack.uncommons.maths.random.SeedGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DevRandomSeedGenerator
implements SeedGenerator {
    private static final File DEV_RANDOM = new File("/dev/random");

    @Override
    public byte[] generateSeed(int length) throws SeedException {
        FileInputStream file = null;
        try {
            int bytesRead;
            file = new FileInputStream(DEV_RANDOM);
            byte[] randomSeed = new byte[length];
            for (int count = 0; count < length; count += bytesRead) {
                bytesRead = file.read(randomSeed, count, length - count);
                if (bytesRead != -1) continue;
                throw new SeedException("EOF encountered reading random data.");
            }
            byte[] byArray = randomSeed;
            return byArray;
        }
        catch (IOException ex) {
            throw new SeedException("Failed reading from " + DEV_RANDOM.getName(), ex);
        }
        catch (SecurityException ex) {
            throw new SeedException("SecurityManager prevented access to " + DEV_RANDOM.getName(), ex);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return "/dev/random";
    }
}

