/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.binary.BinaryUtils;
import com.android.jack.uncommons.maths.random.DevRandomSeedGenerator;
import com.android.jack.uncommons.maths.random.RandomDotOrgSeedGenerator;
import com.android.jack.uncommons.maths.random.SecureRandomSeedGenerator;
import com.android.jack.uncommons.maths.random.SeedException;
import com.android.jack.uncommons.maths.random.SeedGenerator;

public final class DefaultSeedGenerator
implements SeedGenerator {
    private static final String DEBUG_PROPERTY = "com.android.jack.uncommons.maths.random.debug";
    private static final DefaultSeedGenerator INSTANCE = new DefaultSeedGenerator();
    private static final SeedGenerator[] GENERATORS = new SeedGenerator[]{new DevRandomSeedGenerator(), new RandomDotOrgSeedGenerator(), new SecureRandomSeedGenerator()};

    private DefaultSeedGenerator() {
    }

    public static DefaultSeedGenerator getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] generateSeed(int length) {
        for (SeedGenerator generator : GENERATORS) {
            try {
                byte[] seed = generator.generateSeed(length);
                try {
                    boolean debug = System.getProperty(DEBUG_PROPERTY, "false").equals("true");
                    if (debug) {
                        String seedString = BinaryUtils.convertBytesToHexString(seed);
                        System.out.println(seed.length + " bytes of seed data acquired from " + generator + ":");
                        System.out.println("  " + seedString);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return seed;
            }
            catch (SeedException seedException) {
            }
        }
        throw new IllegalStateException("All available seed generation strategies failed.");
    }
}

