/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.rop.cast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.ImplicitBoxingAndUnboxing;
import com.android.jack.transformations.ast.ImplicitCast;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.rop.cast.RopLegalCast;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.With;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Transform body of a JMethod to contain all required cast instructions avoiding register creation into Ropper.")
@Name(value="RopCastLegalizer")
@Constraint(need={JDynamicCastOperation.class}, no={ImplicitBoxingAndUnboxing.class, ImplicitCast.class, JCastOperation.WithIntersectionType.class})
@Transform(add={RopLegalCast.class, JDynamicCastOperation.class}, remove={ThreeAddressCodeForm.class})
@Protect(add={JDynamicCastOperation.class}, unprotect={@With(remove={RopLegalCast.class})})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class RopCastLegalizer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        Visitor visitor = new Visitor(request);
        visitor.accept(method);
        request.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest request;

        public Visitor(@Nonnull TransformationRequest request) {
            this.request = request;
        }

        @Override
        public boolean visit(@Nonnull JDynamicCastOperation cast) {
            JType castTo = cast.getType();
            if (castTo instanceof JPrimitiveType) {
                JType castedFrom = cast.getExpr().getType();
                if (!(castTo != JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || castedFrom != JPrimitiveType.JPrimitiveTypeEnum.LONG.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType())) {
                    JDynamicCastOperation intermediateCastToInt = new JDynamicCastOperation(cast.getSourceInfo(), cast.getExpr(), JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    JDynamicCastOperation replacementCast = new JDynamicCastOperation(cast.getSourceInfo(), (JExpression)intermediateCastToInt, cast.getType());
                    this.request.append(new Replace(cast, replacementCast));
                }
            }
            return super.visit(cast);
        }
    }
}

