/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.NopClassOrInterfaceLoader;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.transformations.lambda.LambdaCaptureSignature;
import com.android.jack.transformations.lambda.LambdaGroup;
import com.android.jack.transformations.lambda.LambdaGroupMarker;
import com.android.jack.transformations.lambda.LambdaGroupingScope;
import com.android.jack.transformations.lambda.LambdaInterfaceSignature;
import com.android.jack.util.NamingTools;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Transform(add={JDefinedClass.class, LambdaGroupMarker.class})
public final class LambdaCollection {
    @Nonnull
    public static final StatisticId<Counter> LAMBDA_GROUP_CLASSES_CREATED = new StatisticId<Counter>("jack.lambda.group-classes-created", "Lambda group classes created", CounterImpl.class, Counter.class);
    @Nonnull
    public static final String LAMBDA_GROUP_CLASS_NAME_PREFIX = "$Lambda$";
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final JClass javaLangObject = Jack.getSession().getPhantomLookup().getClass(CommonTypes.CommonType.OBJECT);
    private final boolean mergeInterfaces = ThreadConfig.get(Options.LAMBDA_MERGE_INTERFACES);
    @Nonnull
    private final LambdaGroupingScope groupingScope = ThreadConfig.get(Options.LAMBDA_GROUPING_SCOPE);
    @Nonnull
    private final ConcurrentHashMap<Key, ConcurrentHashMap<String, JLambda>> lambdaClassSets = new ConcurrentHashMap();

    void addLambda(@Nonnull JDefinedClassOrInterface currentType, @Nonnull String lambdaId, @Nonnull JLambda lambda) {
        this.getOrCreateForLambda(lambdaId, lambda, currentType).put(lambdaId, lambda);
    }

    @Nonnull
    private ConcurrentHashMap<String, JLambda> getOrCreateForLambda(@Nonnull String lambdaId, @Nonnull JLambda lambda, @Nonnull JDefinedClassOrInterface currentType) {
        Key key = this.createKey(lambdaId, lambda, currentType);
        ConcurrentHashMap<String, JLambda> classes = this.lambdaClassSets.get(key);
        if (classes != null) {
            return classes;
        }
        classes = new ConcurrentHashMap();
        ConcurrentHashMap<String, JLambda> existing = this.lambdaClassSets.putIfAbsent(key, classes);
        return existing == null ? classes : existing;
    }

    @Nonnull
    private Key createKey(@Nonnull String lambdaId, @Nonnull JLambda lambda, @Nonnull JDefinedClassOrInterface currentType) {
        String scopeId;
        String interfaceSignatureId = this.mergeInterfaces ? "" : LambdaInterfaceSignature.forLambda(lambda, false).getUniqueId();
        switch (this.groupingScope) {
            case NONE: {
                scopeId = lambdaId;
                break;
            }
            case TYPE: {
                while (currentType.getEnclosingType() != null) {
                    currentType = (JDefinedClassOrInterface)currentType.getEnclosingType();
                }
                scopeId = BinaryQualifiedNameFormatter.getFormatter().getName(currentType);
                break;
            }
            case PACKAGE: {
                scopeId = BinaryQualifiedNameFormatter.getFormatter().getName(currentType.getEnclosingPackage());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new Key(currentType.getEnclosingPackage(), LambdaCaptureSignature.forLambda(lambda), scopeId, interfaceSignatureId);
    }

    void createLambdaClassGroups(@Nonnull JSession session) {
        int nextId = 0;
        TreeMap<Key, ConcurrentHashMap<String, JLambda>> sorted = new TreeMap<Key, ConcurrentHashMap<String, JLambda>>(this.lambdaClassSets);
        for (Map.Entry<Key, ConcurrentHashMap<String, JLambda>> entry : sorted.entrySet()) {
            JDefinedClass groupClass = this.createGroupClass(nextId++, session, entry.getKey().pkg);
            LambdaGroup lambdaGroup = new LambdaGroup((Map<String, JLambda>)entry.getValue(), groupClass, entry.getKey().captureSignature);
            groupClass.addMarker(new LambdaGroupMarker(lambdaGroup));
        }
    }

    @Nonnull
    private JDefinedClass createGroupClass(@Nonnegative int id, @Nonnull JSession session, @Nonnull JPackage pkg) {
        JDefinedClass groupClass = new JDefinedClass(SourceInfo.UNKNOWN, NamingTools.getNonSourceConflictingName(LAMBDA_GROUP_CLASS_NAME_PREFIX + id), 4112, pkg, NopClassOrInterfaceLoader.INSTANCE);
        groupClass.setSuperClass(this.javaLangObject);
        session.addTypeToEmit(groupClass);
        this.tracer.getStatistic(LAMBDA_GROUP_CLASSES_CREATED).incValue();
        return groupClass;
    }

    private static final class Key
    implements Comparable<Key> {
        @Nonnull
        final LambdaCaptureSignature captureSignature;
        @Nonnull
        final JPackage pkg;
        @Nonnull
        final String key;

        Key(@Nonnull JPackage pkg, @Nonnull LambdaCaptureSignature captureSignature, @Nonnull String scopeId, @Nonnull String interfaceSignatureId) {
            this.captureSignature = captureSignature;
            this.pkg = pkg;
            String captureSignatureId = captureSignature.getUniqueId();
            this.key = captureSignatureId + ";;" + interfaceSignatureId + ";;" + scopeId;
        }

        public final int hashCode() {
            return this.key.hashCode();
        }

        public final boolean equals(Object obj) {
            return this == obj || obj instanceof Key && this.key.equals(((Key)obj).key);
        }

        @Override
        public int compareTo(@Nonnull Key other) {
            return this.key.compareTo(other.key);
        }
    }
}

