/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.Jack;
import com.android.jack.google.common.collect.Lists;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.enums.EnumMappingMarker;
import com.android.jack.transformations.enums.SwitchEnumSupport;
import com.android.jack.transformations.enums.opt.EnumFieldMarker;
import com.android.jack.transformations.enums.opt.OptimizationUtil;
import com.android.jack.transformations.request.AppendField;
import com.android.jack.transformations.request.AppendMethod;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.TransformationRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class SwitchMapClassFiller {
    @Nonnull
    private final JArrayType intArray = JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray();
    @CheckForNull
    private JDefinedEnum enumType;
    @CheckForNull
    private JDefinedClass switchMapClass;
    @CheckForNull
    private JMethod syntheticSwitchMapInitializer;
    @CheckForNull
    private JField syntheticSwitchMapField;
    @Nonnull
    private final JSession session = Jack.getSession();

    public synchronized void fillSwitchMapClass(@Nonnull JDefinedEnum enumType, @Nonnull JDefinedClass switchMapClass) {
        this.enumType = enumType;
        this.switchMapClass = switchMapClass;
        TransformationRequest transformRequest = new TransformationRequest(switchMapClass);
        if (switchMapClass.getName().startsWith("SyntheticSwitchmapClass-")) {
            this.createInstanceInitIfNotExists(transformRequest);
        }
        this.createOrUpdateSyntheticInitializer(transformRequest);
        transformRequest.commit();
    }

    private void createInstanceInitIfNotExists(@Nonnull TransformationRequest transformRequest) {
        assert (this.switchMapClass != null);
        try {
            this.switchMapClass.getMethod("<init>", (JType)JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), new JType[0]);
        }
        catch (JMethodLookupException ex) {
            JConstructor initMethod = new JConstructor(SourceInfo.UNKNOWN, this.switchMapClass, 1);
            JBlock block = new JBlock(SourceInfo.UNKNOWN);
            JMethodBody body = new JMethodBody(SourceInfo.UNKNOWN, block);
            initMethod.setBody(body);
            body.updateParents(initMethod);
            JDefinedClass objectClass = this.session.getLookup().getClass("Ljava/lang/Object;");
            JMethod superConstruct = objectClass.getMethod("<init>", (JType)JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), new JType[0]);
            JThis thisLocal = initMethod.getThis();
            assert (thisLocal != null);
            JThisRef thisRef = thisLocal.makeRef(SourceInfo.UNKNOWN);
            JMethodCall superCall = new JMethodCall(SourceInfo.UNKNOWN, thisRef, objectClass, superConstruct.getMethodIdWide(), JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), superConstruct.canBeVirtual());
            transformRequest.append(new AppendStatement(block, superCall.makeStatement()));
            transformRequest.append(new AppendStatement(block, new JReturnStatement(SourceInfo.UNKNOWN, null)));
            transformRequest.append(new AppendMethod(this.switchMapClass, initMethod));
        }
    }

    private void createOrUpdateSyntheticInitializer(@Nonnull TransformationRequest transformRequest) {
        assert (this.enumType != null);
        assert (this.switchMapClass != null);
        assert (this.enumType.containsMarker(EnumFieldMarker.class));
        String methodName = OptimizationUtil.getSyntheticSwitchMapInitializerName(this.enumType);
        try {
            this.syntheticSwitchMapInitializer = this.switchMapClass.getMethod(methodName, (JType)this.intArray, new JType[0]);
            String fieldName = OptimizationUtil.getSyntheticSwitchMapFieldName(this.enumType);
            JFieldId syntheticSwitchMapFieldId = this.switchMapClass.getFieldId(fieldName, this.intArray, FieldKind.STATIC);
            assert (syntheticSwitchMapFieldId != null);
            this.syntheticSwitchMapField = syntheticSwitchMapFieldId.getField();
        }
        catch (JMethodLookupException ex) {
            String fieldName = OptimizationUtil.getSyntheticSwitchMapFieldName(this.enumType);
            this.syntheticSwitchMapField = new JField(SourceInfo.UNKNOWN, fieldName, this.switchMapClass, this.intArray, 4106);
            transformRequest.append(new AppendField(this.switchMapClass, this.syntheticSwitchMapField));
            this.syntheticSwitchMapInitializer = new JMethod(SourceInfo.UNKNOWN, new JMethodId(new JMethodIdWide(methodName, MethodKind.STATIC), this.intArray), this.switchMapClass, 4105);
            transformRequest.append(new AppendMethod(this.switchMapClass, this.syntheticSwitchMapInitializer));
        }
        if (!this.syntheticSwitchMapInitializer.containsMarker(EnumMappingMarker.class)) {
            this.createOrdinalMapping(!this.switchMapClass.getName().startsWith("SyntheticSwitchmapClass-"));
            assert (this.switchMapClass != null);
            if (!(this.switchMapClass.getLocation() instanceof TypeInInputLibraryLocation)) {
                assert (this.syntheticSwitchMapInitializer != null);
                this.syntheticSwitchMapInitializer.setBody(null);
                this.fillSyntheticSwitchMapInitializer(transformRequest);
            }
        }
    }

    private void createOrdinalMapping(boolean packedSwitch) {
        assert (this.enumType != null);
        assert (this.switchMapClass != null);
        assert (this.syntheticSwitchMapInitializer != null);
        assert (!this.syntheticSwitchMapInitializer.containsMarker(EnumMappingMarker.class));
        assert (this.enumType.containsMarker(EnumFieldMarker.class));
        int packedCompileTimeOrdinal = 1;
        int unpackedCompileTimeOrdinal = 1;
        HashSet<JFieldId> usedEnumFields = Sets.newHashSet();
        EnumFieldMarker enumFieldMarker = this.enumType.getMarker(EnumFieldMarker.class);
        if (packedSwitch && this.switchMapClass.containsMarker(SwitchEnumSupport.UsedEnumField.class)) {
            SwitchEnumSupport.UsedEnumField usedFieldMarker = this.switchMapClass.getMarker(SwitchEnumSupport.UsedEnumField.class);
            assert (usedFieldMarker != null);
            usedEnumFields.addAll(usedFieldMarker.getEnumFields());
            unpackedCompileTimeOrdinal = usedEnumFields.size() + 1;
        } else {
            enumFieldMarker.sortEnumFields();
        }
        EnumMappingMarker mappingMarker = new EnumMappingMarker();
        this.syntheticSwitchMapInitializer.addMarker(mappingMarker);
        for (JEnumField enumField : enumFieldMarker.getEnumFields()) {
            JFieldId enumFieldId = enumField.getId();
            if (usedEnumFields.contains(enumField.getId())) {
                mappingMarker.addMapping(enumFieldId, packedCompileTimeOrdinal++);
                continue;
            }
            mappingMarker.addMapping(enumFieldId, unpackedCompileTimeOrdinal++);
        }
    }

    private void fillSyntheticSwitchMapInitializer(@Nonnull TransformationRequest transformRequest) {
        assert (this.switchMapClass != null);
        assert (this.syntheticSwitchMapField != null);
        assert (this.syntheticSwitchMapInitializer != null);
        assert (this.syntheticSwitchMapInitializer.getBody() == null);
        JBlock bodyBlock = new JBlock(SourceInfo.UNKNOWN);
        JMethodBody methodBody = new JMethodBody(SourceInfo.UNKNOWN, bodyBlock);
        this.syntheticSwitchMapInitializer.setBody(methodBody);
        methodBody.updateParents(this.syntheticSwitchMapInitializer);
        LocalVarCreator localVarCreator = new LocalVarCreator(this.syntheticSwitchMapInitializer, "loc");
        JBinaryOperation checkNullExpr = JBinaryOperation.create(SourceInfo.UNKNOWN, JBinaryOperator.NEQ, new JFieldRef(SourceInfo.UNKNOWN, null, this.syntheticSwitchMapField.getId(), this.switchMapClass), new JNullLiteral(SourceInfo.UNKNOWN));
        JBlock thenBlock = new JBlock(SourceInfo.UNKNOWN);
        transformRequest.append(new AppendStatement(thenBlock, new JReturnStatement(SourceInfo.UNKNOWN, new JFieldRef(SourceInfo.UNKNOWN, null, this.syntheticSwitchMapField.getId(), this.switchMapClass))));
        JIfStatement ifStmt = new JIfStatement(SourceInfo.UNKNOWN, checkNullExpr, thenBlock, null);
        transformRequest.append(new AppendStatement(bodyBlock, ifStmt));
        this.createSwitchMapInitializerBlock(transformRequest, localVarCreator, bodyBlock);
    }

    private void createSwitchMapInitializerBlock(@Nonnull TransformationRequest transformRequest, @Nonnull LocalVarCreator localVarCreator, @Nonnull JBlock initializerMethodBlock) {
        assert (this.enumType != null);
        JMethod valuesMethod = this.enumType.getMethod("values", (JType)this.enumType.getArray(), new JType[0]);
        JArrayLength valuesLength = new JArrayLength(SourceInfo.UNKNOWN, new JMethodCall(SourceInfo.UNKNOWN, null, this.enumType, valuesMethod.getMethodIdWide(), valuesMethod.getType(), valuesMethod.canBeVirtual()));
        JLocal switchmapLocal = this.createSwitchmapArrayStatement(localVarCreator, transformRequest, initializerMethodBlock, valuesLength);
        assert (this.syntheticSwitchMapField != null);
        assert (this.switchMapClass != null);
        JExpressionStatement putStaticFieldStmt = new JExpressionStatement(SourceInfo.UNKNOWN, JBinaryOperation.create(SourceInfo.UNKNOWN, JBinaryOperator.ASG, new JFieldRef(SourceInfo.UNKNOWN, null, this.syntheticSwitchMapField.getId(), this.switchMapClass), switchmapLocal.makeRef(SourceInfo.UNKNOWN)));
        transformRequest.append(new AppendStatement(initializerMethodBlock, putStaticFieldStmt));
        this.createStatementsInitializingSwitchMapArrayField(transformRequest, initializerMethodBlock, switchmapLocal);
        transformRequest.append(new AppendStatement(initializerMethodBlock, new JReturnStatement(SourceInfo.UNKNOWN, switchmapLocal.makeRef(SourceInfo.UNKNOWN))));
    }

    private void createStatementsInitializingSwitchMapArrayField(@Nonnull TransformationRequest transformRequest, @Nonnull JBlock block, @Nonnull JLocal switchmapLocal) {
        assert (this.syntheticSwitchMapInitializer != null);
        EnumMappingMarker enumMappingMarker = this.syntheticSwitchMapInitializer.getMarker(EnumMappingMarker.class);
        assert (enumMappingMarker != null);
        TreeMap<JFieldId, Integer> enumFieldsMap = new TreeMap<JFieldId, Integer>(new Comparator<JFieldId>(){

            @Override
            public int compare(JFieldId field1, JFieldId field2) {
                return field1.getName().compareTo(field2.getName());
            }
        });
        enumFieldsMap.putAll(enumMappingMarker.getMapping());
        for (Map.Entry enumFieldEntry : enumFieldsMap.entrySet()) {
            JBlock tryBlock = new JBlock(SourceInfo.UNKNOWN);
            JCatchBlock noSuchFieldExCatchBlock = this.createCatchBlock(this.session.getLookup().getClass("Ljava/lang/NoSuchFieldError;"));
            JFieldId enumFieldId = (JFieldId)enumFieldEntry.getKey();
            Integer compileTimeOrdinal = (Integer)enumFieldEntry.getValue();
            assert (this.enumType != null);
            JFieldRef enumFieldExpr = new JFieldRef(SourceInfo.UNKNOWN, null, enumFieldId, this.enumType);
            JMethod ordinalMethod = this.session.getLookup().getClass("Ljava/lang/Enum;").getMethod("ordinal", (JType)JPrimitiveType.JPrimitiveTypeEnum.INT.getType(), new JType[0]);
            JMethodCall invocOrdinalExpr = new JMethodCall(SourceInfo.UNKNOWN, enumFieldExpr, this.enumType, ordinalMethod.getMethodIdWide(), JPrimitiveType.JPrimitiveTypeEnum.INT.getType(), ordinalMethod.canBeVirtual());
            transformRequest.append(new AppendStatement(tryBlock, JBinaryOperation.create(SourceInfo.UNKNOWN, JBinaryOperator.ASG, new JArrayRef(SourceInfo.UNKNOWN, switchmapLocal.makeRef(SourceInfo.UNKNOWN), invocOrdinalExpr), new JIntLiteral(SourceInfo.UNKNOWN, compileTimeOrdinal)).makeStatement()));
            transformRequest.append(new AppendStatement(block, new JTryStatement(SourceInfo.UNKNOWN, Collections.emptyList(), tryBlock, Lists.newArrayList(noSuchFieldExCatchBlock), null)));
        }
    }

    private JLocal createSwitchmapArrayStatement(@Nonnull LocalVarCreator localVarCreator, @Nonnull TransformationRequest transformRequest, @Nonnull JBlock block, @Nonnull JExpression capacityExpr) {
        ArrayList<JExpression> dims = Lists.newArrayList(capacityExpr);
        JNewArray newArrayExpr = JNewArray.createWithDims(SourceInfo.UNKNOWN, this.intArray, dims);
        JLocal switchMapLocal = localVarCreator.createTempLocal(this.intArray, SourceInfo.UNKNOWN, transformRequest);
        JExpressionStatement newArrayStmt = new JExpressionStatement(SourceInfo.UNKNOWN, JBinaryOperation.create(SourceInfo.UNKNOWN, JBinaryOperator.ASG, switchMapLocal.makeRef(SourceInfo.UNKNOWN), newArrayExpr));
        transformRequest.append(new AppendStatement(block, newArrayStmt));
        return switchMapLocal;
    }

    private JCatchBlock createCatchBlock(@Nonnull JDefinedClass exceptionType) {
        assert (this.syntheticSwitchMapInitializer != null);
        JLocal catchLocal = new JLocal(SourceInfo.UNKNOWN, "ex", exceptionType, 4096, (JMethodBody)this.syntheticSwitchMapInitializer.getBody());
        JCatchBlock catchBlock = new JCatchBlock(SourceInfo.UNKNOWN, Collections.singletonList(exceptionType), catchLocal);
        return catchBlock;
    }
}

