/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.google.common.collect.HashMultimap;
import com.android.jack.google.common.collect.Multimap;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JPackage;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Marker specifies how many user classes uses an enum in switch statements under a package.")
@ValidOn(value={JPackage.class})
public final class SwitchEnumUsageMarker
implements Marker {
    @Nonnull
    private final Multimap<JDefinedClass, JDefinedEnum> userClasses = HashMultimap.create();
    @Nonnull
    private final JPackage enclosingPackage;

    public SwitchEnumUsageMarker(@Nonnull JPackage enclosingPackage) {
        this.enclosingPackage = enclosingPackage;
    }

    public synchronized boolean addEnumUsage(@Nonnull JDefinedClass userClass, @Nonnull JDefinedEnum enumType) {
        return this.userClasses.put(userClass, enumType);
    }

    @Nonnegative
    public synchronized int getUses() {
        return this.userClasses.size();
    }

    public synchronized Set<JDefinedEnum> getUsedEnumsType() {
        HashSet<JDefinedEnum> usedEnumsType = Sets.newHashSet();
        for (JDefinedEnum enumType : this.userClasses.values()) {
            usedEnumsType.add(enumType);
        }
        return usedEnumsType;
    }

    @Nonnull
    public JPackage getPackage() {
        return this.enclosingPackage;
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }
}

