/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNeqOperation;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.enums.EnumMappingMarker;
import com.android.jack.transformations.enums.opt.OptimizationUtil;
import com.android.jack.transformations.enums.opt.SwitchMapClassFiller;
import com.android.jack.transformations.enums.opt.SyntheticClassManager;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Add support to optimize enum switch statements.")
@Name(value="OptimizedSwitchEnumSupport")
@Synchronized
@Constraint(need={JSwitchStatement.class, JEnumField.class, JEnumLiteral.class, OriginalNames.class})
@Transform(modify={JSwitchStatement.class}, add={EnumMappingMarker.class, JNewArray.class, JAsgOperation.NonReusedAsg.class, JMethodCall.class, JArrayRef.class, JArrayLength.class, JLocalRef.class, JField.class, JMethod.class, JMethodBody.class, JFieldRef.class, JNullLiteral.class, JLocal.class, JIfStatement.class, JReturnStatement.class, JBlock.class, JTryStatement.class, JIntLiteral.class, JExpressionStatement.class, JNeqOperation.class, JDefinedClass.class}, remove={JSwitchStatement.SwitchWithEnum.class, ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class})
@Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JSession.class)
public class OptimizedSwitchEnumSupport
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final SwitchMapClassFiller classFiller = new SwitchMapClassFiller();
    @Nonnull
    private final OptimizationUtil supportUtil = new OptimizationUtil();
    @Nonnull
    private final SyntheticClassManager manager = new SyntheticClassManager(this.supportUtil);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        JDefinedClassOrInterface definedClass = method.getEnclosingType();
        if (!(definedClass instanceof JDefinedClass) || method.isNative() || method.isAbstract()) {
            return;
        }
        TransformationRequest transformRequest = new TransformationRequest(definedClass);
        Visitor visitor = new Visitor(transformRequest, (JDefinedClass)definedClass);
        visitor.accept(method);
        transformRequest.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest transformRequest;
        @Nonnull
        private final JDefinedClass enclosingClass;

        public Visitor(@Nonnull TransformationRequest transformRequest, JDefinedClass definedClass) {
            this.transformRequest = transformRequest;
            this.enclosingClass = definedClass;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            JExpression switchExpr = switchStmt.getExpr();
            JType switchExprType = switchExpr.getType();
            if (switchExprType instanceof JDefinedEnum) {
                JDefinedEnum enumType = (JDefinedEnum)switchExprType;
                JDefinedClass switchMapClass = this.getSwitchMapClass(enumType, true);
                if (switchMapClass == null) {
                    switchMapClass = this.enclosingClass;
                }
                OptimizedSwitchEnumSupport.this.classFiller.fillSwitchMapClass(enumType, switchMapClass);
                String syntheticInitializerName = OptimizationUtil.getSyntheticSwitchMapInitializerName(enumType);
                JMethod syntheticInitializer = switchMapClass.getMethod(syntheticInitializerName, (JType)JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray(), new JType[0]);
                JMethodCall getSwitchMapInvocExpr = new JMethodCall(switchStmt.getSourceInfo(), null, switchMapClass, syntheticInitializer.getMethodIdWide(), syntheticInitializer.getType(), syntheticInitializer.canBeVirtual());
                JMethod ordinalMethod = Jack.getSession().getLookup().getClass("Ljava/lang/Enum;").getMethod("ordinal", (JType)JPrimitiveType.JPrimitiveTypeEnum.INT.getType(), Collections.emptyList());
                this.transformRequest.append(new Replace(switchExpr, new JArrayRef(switchStmt.getSourceInfo(), getSwitchMapInvocExpr, new JMethodCall(switchStmt.getSourceInfo(), switchExpr, enumType, ordinalMethod.getMethodIdWide(), ordinalMethod.getType(), ordinalMethod.canBeVirtual()))));
            }
            return super.visit(switchStmt);
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStmt) {
            JLiteral caseExpr = caseStmt.getExpr();
            if (caseExpr instanceof JEnumLiteral) {
                JEnumLiteral enumLiteral = (JEnumLiteral)caseExpr;
                JDefinedEnum enumType = (JDefinedEnum)enumLiteral.getType();
                JDefinedClass switchmapClass = this.getSwitchMapClass(enumType, false);
                if (switchmapClass == null) {
                    switchmapClass = this.enclosingClass;
                }
                String syntheticInitializerName = OptimizationUtil.getSyntheticSwitchMapInitializerName(enumType);
                JMethod syntheticInitializer = switchmapClass.getMethod(syntheticInitializerName, (JType)JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray(), new JType[0]);
                EnumMappingMarker ordinalMapping = syntheticInitializer.getMarker(EnumMappingMarker.class);
                assert (ordinalMapping != null);
                JFieldId enumFieldId = enumLiteral.getFieldId();
                Map<JFieldId, Integer> ordinalMap = ordinalMapping.getMapping();
                Integer compileTimeOrdinal = ordinalMap.get(enumFieldId);
                assert (compileTimeOrdinal != null);
                Replace replace = new Replace(caseExpr, new JIntLiteral(caseStmt.getSourceInfo(), compileTimeOrdinal));
                this.transformRequest.append(replace);
            }
            return super.visit(caseStmt);
        }

        @CheckForNull
        private JDefinedClass getSwitchMapClass(@Nonnull JDefinedEnum enumType, boolean createIfNotExist) {
            String syntheticFieldName = OptimizationUtil.getSyntheticSwitchMapFieldName(enumType);
            for (JField field : this.enclosingClass.getFields()) {
                if (!OptimizedSwitchEnumSupport.this.supportUtil.isSyntheticSwitchMapField(field) || !syntheticFieldName.equals(field.getName())) continue;
                return this.enclosingClass;
            }
            return OptimizedSwitchEnumSupport.this.manager.getOrCreateSyntheticClass(enumType, createIfNotExist);
        }
    }
}

