/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.switches;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.ast.UnassignedValues;
import com.android.jack.transformations.ast.switches.UselessSwitches;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.With;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;

@Description(value="Removes switches with only default case.")
@Name(value="UselessSwitchesRemover")
@Constraint(need={JSwitchStatement.class, NoImplicitBlock.class})
@Transform(add={UnassignedValues.class}, remove={ThreeAddressCodeForm.class, UselessSwitches.class})
@Protect(add={JSwitchStatement.class, JExpressionStatement.class, JExpressionStatement.class}, unprotect={@With(add={UselessSwitches.class})})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UselessSwitchesRemover
implements RunnableSchedulable<JMethod> {
    public static final StatisticId<Percent> SWITCH_WITH_CST = new StatisticId<Percent>("jack.statement.switch.constant", "Switch that have a constant expression", PercentImpl.class, Percent.class);
    public static final StatisticId<Percent> SWITCH_WITH_ONLY_DEFAULT = new StatisticId<Percent>("jack.statement.switch.default", "Switch that have only a default case", PercentImpl.class, Percent.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final Stack<Boolean> removeBreakOrCase = new Stack();

        public Visitor(TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement jswitch) {
            this.removeBreakOrCase.push(jswitch.getCases().isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            return super.visit(jswitch);
        }

        @Override
        public boolean visit(@Nonnull JDoStatement doStmt) {
            this.removeBreakOrCase.push(Boolean.FALSE);
            return super.visit(doStmt);
        }

        @Override
        public void endVisit(@Nonnull JDoStatement x) {
            this.removeBreakOrCase.pop();
            super.endVisit(x);
        }

        @Override
        public boolean visit(@Nonnull JForStatement x) {
            this.removeBreakOrCase.push(Boolean.FALSE);
            return super.visit(x);
        }

        @Override
        public void endVisit(@Nonnull JForStatement x) {
            this.removeBreakOrCase.pop();
            super.endVisit(x);
        }

        @Override
        public boolean visit(@Nonnull JWhileStatement x) {
            this.removeBreakOrCase.push(Boolean.FALSE);
            return super.visit(x);
        }

        @Override
        public void endVisit(@Nonnull JWhileStatement x) {
            this.removeBreakOrCase.pop();
            super.endVisit(x);
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement x) {
            this.removeBreakOrCase.push(Boolean.FALSE);
            return super.visit(x);
        }

        @Override
        public void endVisit(@Nonnull JLabeledStatement x) {
            this.removeBreakOrCase.pop();
            super.endVisit(x);
        }

        @Override
        public void endVisit(@Nonnull JCaseStatement caseStmt) {
            boolean remove = this.removeBreakOrCase.peek();
            if (remove && caseStmt.getExpr() == null) {
                this.tr.append(new Remove(caseStmt));
            } else assert (!remove);
            super.endVisit(caseStmt);
        }

        @Override
        public void endVisit(@Nonnull JBreakStatement breakStmt) {
            if (this.removeBreakOrCase.peek().booleanValue()) {
                this.tr.append(new Remove(breakStmt));
            }
            super.endVisit(breakStmt);
        }

        @Override
        public void endVisit(@Nonnull JSwitchStatement jswitch) {
            UselessSwitchesRemover.this.tracer.getStatistic(SWITCH_WITH_CST).add(jswitch.getExpr() instanceof JValueLiteral);
            if (this.removeBreakOrCase.pop().booleanValue()) {
                this.tr.append(new AppendBefore(jswitch, jswitch.getExpr().makeStatement()));
                JBlock switchBody = jswitch.getBody();
                List<JStatement> stmts = switchBody.getStatements();
                if (stmts.size() >= 1) {
                    this.tr.append(new AppendBefore(jswitch, switchBody));
                }
                this.tr.append(new Remove(jswitch));
                UselessSwitchesRemover.this.tracer.getStatistic(SWITCH_WITH_ONLY_DEFAULT).addTrue();
            } else {
                UselessSwitchesRemover.this.tracer.getStatistic(SWITCH_WITH_ONLY_DEFAULT).addFalse();
            }
            super.endVisit(jswitch);
        }
    }
}

