/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.switches;

import com.android.jack.Options;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Checks that there is no useless cases into switch statement.")
@Constraint(need={JSwitchStatement.class})
@Support(value={SanityChecks.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UselessCaseChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Checker checker = new Checker();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        this.checker.accept(method);
    }

    private static class Checker
    extends JVisitor {
        private Checker() {
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStmt) {
            JStatement nextStmt = caseStmt;
            do {
                nextStmt = ControlFlowHelper.getNextStatement(nextStmt);
                while (nextStmt instanceof JStatementList) {
                    nextStmt = ControlFlowHelper.getConcreteStatement((JStatementList)nextStmt);
                }
            } while (nextStmt instanceof JCaseStatement && ((JCaseStatement)nextStmt).getExpr() != null);
            if (nextStmt instanceof JCaseStatement && ((JCaseStatement)nextStmt).getExpr() == null) {
                throw new AssertionError((Object)"Useless cases into switch exist.");
            }
            return super.visit(caseStmt);
        }
    }
}

